<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference Structs
 * Meta informations extracted from the WSDL
 * - type: ds:ReferenceType
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The href
     * Meta informations extracted from the WSDL
     * - ref: xlink:href
     * - use: required
     * @var string
     */
    public $href;
    /**
     * The Schema
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Schema
     * @var \Sabre\QueueCount\Structs\Schema[]
     */
    public $Schema;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \Sabre\QueueCount\Structs\Description[]
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - fixed: simple
     * - ref: xlink:type
     * @var string
     */
    public $type;
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - ref: xlink:role
     * @var string
     */
    public $role;
    /**
     * Constructor method for Reference
     * @uses Reference::setHref()
     * @uses Reference::setSchema()
     * @uses Reference::setDescription()
     * @uses Reference::setAny()
     * @uses Reference::setId()
     * @uses Reference::setType()
     * @uses Reference::setRole()
     * @param string $href
     * @param \Sabre\QueueCount\Structs\Schema[] $schema
     * @param \Sabre\QueueCount\Structs\Description[] $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $type
     * @param string $role
     */
    public function __construct($href = null, array $schema = array(), array $description = array(), \DOMDocument $any = null, $id = null, $type = null, $role = null)
    {
        $this
            ->setHref($href)
            ->setSchema($schema)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setType($type)
            ->setRole($role);
    }
    /**
     * Get href value
     * @return string
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function setHref($href = null)
    {
        // validation for constraint: string
        if (!is_null($href) && !is_string($href)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($href)), __LINE__);
        }
        $this->href = $href;
        return $this;
    }
    /**
     * Get Schema value
     * @return \Sabre\QueueCount\Structs\Schema[]|null
     */
    public function getSchema()
    {
        return $this->Schema;
    }
    /**
     * Set Schema value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Schema[] $schema
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function setSchema(array $schema = array())
    {
        foreach ($schema as $referenceSchemaItem) {
            // validation for constraint: itemType
            if (!$referenceSchemaItem instanceof \Sabre\QueueCount\Structs\Schema) {
                throw new \InvalidArgumentException(sprintf('The Schema property can only contain items of \Sabre\QueueCount\Structs\Schema, "%s" given', is_object($referenceSchemaItem) ? get_class($referenceSchemaItem) : gettype($referenceSchemaItem)), __LINE__);
            }
        }
        $this->Schema = $schema;
        return $this;
    }
    /**
     * Add item to Schema value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Schema $item
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function addToSchema(\Sabre\QueueCount\Structs\Schema $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\Schema) {
            throw new \InvalidArgumentException(sprintf('The Schema property can only contain items of \Sabre\QueueCount\Structs\Schema, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Schema[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \Sabre\QueueCount\Structs\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Description[] $description
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $referenceDescriptionItem) {
            // validation for constraint: itemType
            if (!$referenceDescriptionItem instanceof \Sabre\QueueCount\Structs\Description) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \Sabre\QueueCount\Structs\Description, "%s" given', is_object($referenceDescriptionItem) ? get_class($referenceDescriptionItem) : gettype($referenceDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Description $item
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function addToDescription(\Sabre\QueueCount\Structs\Description $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\Description) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \Sabre\QueueCount\Structs\Description, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\QueueCount\Structs\Reference::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\Reference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
