<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInfo Structs
 * @subpackage Structs
 */
class QueueInfo extends AbstractStructBase
{
    /**
     * The QueueIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\QueueIdentifier[]
     */
    public $QueueIdentifier;
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $DateTime;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * Constructor method for QueueInfo
     * @uses QueueInfo::setQueueIdentifier()
     * @uses QueueInfo::setDateTime()
     * @uses QueueInfo::setPseudoCityCode()
     * @param \Sabre\QueueCount\Structs\QueueIdentifier[] $queueIdentifier
     * @param string $dateTime
     * @param string $pseudoCityCode
     */
    public function __construct(array $queueIdentifier = array(), $dateTime = null, $pseudoCityCode = null)
    {
        $this
            ->setQueueIdentifier($queueIdentifier)
            ->setDateTime($dateTime)
            ->setPseudoCityCode($pseudoCityCode);
    }
    /**
     * Get QueueIdentifier value
     * @return \Sabre\QueueCount\Structs\QueueIdentifier[]|null
     */
    public function getQueueIdentifier()
    {
        return $this->QueueIdentifier;
    }
    /**
     * Set QueueIdentifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\QueueIdentifier[] $queueIdentifier
     * @return \Sabre\QueueCount\Structs\QueueInfo
     */
    public function setQueueIdentifier(array $queueIdentifier = array())
    {
        foreach ($queueIdentifier as $queueInfoQueueIdentifierItem) {
            // validation for constraint: itemType
            if (!$queueInfoQueueIdentifierItem instanceof \Sabre\QueueCount\Structs\QueueIdentifier) {
                throw new \InvalidArgumentException(sprintf('The QueueIdentifier property can only contain items of \Sabre\QueueCount\Structs\QueueIdentifier, "%s" given', is_object($queueInfoQueueIdentifierItem) ? get_class($queueInfoQueueIdentifierItem) : gettype($queueInfoQueueIdentifierItem)), __LINE__);
            }
        }
        $this->QueueIdentifier = $queueIdentifier;
        return $this;
    }
    /**
     * Add item to QueueIdentifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\QueueIdentifier $item
     * @return \Sabre\QueueCount\Structs\QueueInfo
     */
    public function addToQueueIdentifier(\Sabre\QueueCount\Structs\QueueIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\QueueIdentifier) {
            throw new \InvalidArgumentException(sprintf('The QueueIdentifier property can only contain items of \Sabre\QueueCount\Structs\QueueIdentifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->QueueIdentifier[] = $item;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \Sabre\QueueCount\Structs\QueueInfo
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dateTime) && !preg_match('/(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}/', $dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}", "%s" given', var_export($dateTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\QueueCount\Structs\QueueInfo
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\QueueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
