<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProblemBase Structs
 * @subpackage Structs
 */
class ProblemBase extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: An indication of the source of error when processing the request.
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Impact of the error on process completion.
     * - use: required
     * @var string
     */
    public $status;
    /**
     * The timeStamp
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for ProblemBase
     * @uses ProblemBase::setType()
     * @uses ProblemBase::setStatus()
     * @uses ProblemBase::setTimeStamp()
     * @param string $type
     * @param string $status
     * @param string $timeStamp
     */
    public function __construct($type = null, $status = null, $timeStamp = null)
    {
        $this
            ->setType($type)
            ->setStatus($status)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \Sabre\QueueCount\Enums\ErrorType::valueIsValid()
     * @uses \Sabre\QueueCount\Enums\ErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\QueueCount\Structs\ProblemBase
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Sabre\QueueCount\Enums\ErrorType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Sabre\QueueCount\Enums\ErrorType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Sabre\QueueCount\Enums\CompletionCodes::valueIsValid()
     * @uses \Sabre\QueueCount\Enums\CompletionCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Sabre\QueueCount\Structs\ProblemBase
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Sabre\QueueCount\Enums\CompletionCodes::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \Sabre\QueueCount\Enums\CompletionCodes::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \Sabre\QueueCount\Structs\ProblemBase
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($timeStamp) && !preg_match('/(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}/', $timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}", "%s" given', var_export($timeStamp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\ProblemBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
