<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorList Structs
 * @subpackage Structs
 */
class ErrorList extends AbstractStructBase
{
    /**
     * The highestSeverity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $highestSeverity;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:Error
     * @var \Sabre\QueueCount\Structs\Error[]
     */
    public $Error;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for ErrorList
     * @uses ErrorList::setHighestSeverity()
     * @uses ErrorList::setError()
     * @uses ErrorList::setAny()
     * @uses ErrorList::setId()
     * @uses ErrorList::setVersion()
     * @param string $highestSeverity
     * @param \Sabre\QueueCount\Structs\Error[] $error
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct($highestSeverity = null, array $error = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setError($error)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get highestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->highestSeverity;
    }
    /**
     * Set highestSeverity value
     * @uses \Sabre\QueueCount\Enums\Severity_type::valueIsValid()
     * @uses \Sabre\QueueCount\Enums\Severity_type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \Sabre\QueueCount\Structs\ErrorList
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\Sabre\QueueCount\Enums\Severity_type::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $highestSeverity, implode(', ', \Sabre\QueueCount\Enums\Severity_type::getValidValues())), __LINE__);
        }
        $this->highestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Error value
     * @return \Sabre\QueueCount\Structs\Error[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Error[] $error
     * @return \Sabre\QueueCount\Structs\ErrorList
     */
    public function setError(array $error = array())
    {
        foreach ($error as $errorListErrorItem) {
            // validation for constraint: itemType
            if (!$errorListErrorItem instanceof \Sabre\QueueCount\Structs\Error) {
                throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \Sabre\QueueCount\Structs\Error, "%s" given', is_object($errorListErrorItem) ? get_class($errorListErrorItem) : gettype($errorListErrorItem)), __LINE__);
            }
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\Error $item
     * @return \Sabre\QueueCount\Structs\ErrorList
     */
    public function addToError(\Sabre\QueueCount\Structs\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\Error) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \Sabre\QueueCount\Structs\Error, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\QueueCount\Structs\ErrorList::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\QueueCount\Structs\ErrorList
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\QueueCount\Structs\ErrorList
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\QueueCount\Structs\ErrorList
     */
    public function setVersion($version = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($version) && strlen($version) < 1) || (is_array($version) && count($version) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\ErrorList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
