<?php

namespace Sabre\QueueCount\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationResults Structs
 * Meta informations extracted from the WSDL
 * - documentation: ApplicationResults can be used anywhere where Results is referenced, specifically as the contents of a Sabre SOAP Fault/detail element.
 * - substitutionGroup: Results
 * - type: ApplicationResults
 * @subpackage Structs
 */
class ApplicationResults extends Results
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $status;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\ProblemInformation[]
     */
    public $Success;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\ProblemInformation[]
     */
    public $Error;
    /**
     * The Warning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\QueueCount\Structs\ProblemInformation[]
     */
    public $Warning;
    /**
     * Constructor method for ApplicationResults
     * @uses ApplicationResults::setStatus()
     * @uses ApplicationResults::setSuccess()
     * @uses ApplicationResults::setError()
     * @uses ApplicationResults::setWarning()
     * @param string $status
     * @param \Sabre\QueueCount\Structs\ProblemInformation[] $success
     * @param \Sabre\QueueCount\Structs\ProblemInformation[] $error
     * @param \Sabre\QueueCount\Structs\ProblemInformation[] $warning
     */
    public function __construct($status = null, array $success = array(), array $error = array(), array $warning = array())
    {
        $this
            ->setStatus($status)
            ->setSuccess($success)
            ->setError($error)
            ->setWarning($warning);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Sabre\QueueCount\Enums\CompletionCodes::valueIsValid()
     * @uses \Sabre\QueueCount\Enums\CompletionCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Sabre\QueueCount\Enums\CompletionCodes::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \Sabre\QueueCount\Enums\CompletionCodes::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get Success value
     * @return \Sabre\QueueCount\Structs\ProblemInformation[]|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ProblemInformation[] $success
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public function setSuccess(array $success = array())
    {
        foreach ($success as $applicationResultsSuccessItem) {
            // validation for constraint: itemType
            if (!$applicationResultsSuccessItem instanceof \Sabre\QueueCount\Structs\ProblemInformation) {
                throw new \InvalidArgumentException(sprintf('The Success property can only contain items of \Sabre\QueueCount\Structs\ProblemInformation, "%s" given', is_object($applicationResultsSuccessItem) ? get_class($applicationResultsSuccessItem) : gettype($applicationResultsSuccessItem)), __LINE__);
            }
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Add item to Success value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ProblemInformation $item
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public function addToSuccess(\Sabre\QueueCount\Structs\ProblemInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\ProblemInformation) {
            throw new \InvalidArgumentException(sprintf('The Success property can only contain items of \Sabre\QueueCount\Structs\ProblemInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Success[] = $item;
        return $this;
    }
    /**
     * Get Error value
     * @return \Sabre\QueueCount\Structs\ProblemInformation[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ProblemInformation[] $error
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public function setError(array $error = array())
    {
        foreach ($error as $applicationResultsErrorItem) {
            // validation for constraint: itemType
            if (!$applicationResultsErrorItem instanceof \Sabre\QueueCount\Structs\ProblemInformation) {
                throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \Sabre\QueueCount\Structs\ProblemInformation, "%s" given', is_object($applicationResultsErrorItem) ? get_class($applicationResultsErrorItem) : gettype($applicationResultsErrorItem)), __LINE__);
            }
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ProblemInformation $item
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public function addToError(\Sabre\QueueCount\Structs\ProblemInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\ProblemInformation) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \Sabre\QueueCount\Structs\ProblemInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \Sabre\QueueCount\Structs\ProblemInformation[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ProblemInformation[] $warning
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public function setWarning(array $warning = array())
    {
        foreach ($warning as $applicationResultsWarningItem) {
            // validation for constraint: itemType
            if (!$applicationResultsWarningItem instanceof \Sabre\QueueCount\Structs\ProblemInformation) {
                throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \Sabre\QueueCount\Structs\ProblemInformation, "%s" given', is_object($applicationResultsWarningItem) ? get_class($applicationResultsWarningItem) : gettype($applicationResultsWarningItem)), __LINE__);
            }
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueCount\Structs\ProblemInformation $item
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public function addToWarning(\Sabre\QueueCount\Structs\ProblemInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sabre\QueueCount\Structs\ProblemInformation) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \Sabre\QueueCount\Structs\ProblemInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueCount\Structs\ApplicationResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
