<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service Structs
 * Meta informations extracted from the WSDL
 * - type: Service
 * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The operation
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $operation;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * The ttl
     * @var int
     */
    public $ttl;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for Service
     * @uses Service::set_()
     * @uses Service::setOperation()
     * @uses Service::setVersion()
     * @uses Service::setTtl()
     * @uses Service::setType()
     * @param string $_
     * @param string $operation
     * @param string $version
     * @param int $ttl
     * @param string $type
     */
    public function __construct($_ = null, $operation = null, $version = null, $ttl = null, $type = null)
    {
        $this
            ->set_($_)
            ->setOperation($operation)
            ->setVersion($version)
            ->setTtl($ttl)
            ->setType($type);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\QueueAccess\Structs\Service
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return \Sabre\QueueAccess\Structs\Service
     */
    public function setOperation($operation = null)
    {
        $this->operation = $operation;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\QueueAccess\Structs\Service
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get ttl value
     * @return int|null
     */
    public function getTtl()
    {
        return $this->ttl;
    }
    /**
     * Set ttl value
     * @param int $ttl
     * @return \Sabre\QueueAccess\Structs\Service
     */
    public function setTtl($ttl = null)
    {
        $this->ttl = $ttl;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\QueueAccess\Structs\Service
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
