<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Selection Structs
 * @subpackage Structs
 */
class Selection extends AbstractStructBase
{
    /**
     * The Criteria
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Criteria;
    /**
     * The Function
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Function;
    /**
     * Constructor method for Selection
     * @uses Selection::setCriteria()
     * @uses Selection::setFunction()
     * @param string $criteria
     * @param string $function
     */
    public function __construct($criteria = null, $function = null)
    {
        $this
            ->setCriteria($criteria)
            ->setFunction($function);
    }
    /**
     * Get Criteria value
     * @return string
     */
    public function getCriteria()
    {
        return $this->Criteria;
    }
    /**
     * Set Criteria value
     * @param string $criteria
     * @return \Sabre\QueueAccess\Structs\Selection
     */
    public function setCriteria($criteria = null)
    {
        $this->Criteria = $criteria;
        return $this;
    }
    /**
     * Get Function value
     * @return string
     */
    public function getFunction()
    {
        return $this->Function;
    }
    /**
     * Set Function value
     * @param string $function
     * @return \Sabre\QueueAccess\Structs\Selection
     */
    public function setFunction($function = null)
    {
        $this->Function = $function;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\Selection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
