<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueAccessRS Structs
 * @subpackage Structs
 */
class QueueAccessRS extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - ref: stl:ApplicationResults
     * @var \Sabre\QueueAccess\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The Line
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\Line[]
     */
    public $Line;
    /**
     * The Paragraph
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\Paragraph
     */
    public $Paragraph;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for QueueAccessRS
     * @uses QueueAccessRS::setApplicationResults()
     * @uses QueueAccessRS::setLine()
     * @uses QueueAccessRS::setParagraph()
     * @uses QueueAccessRS::setVersion()
     * @param \Sabre\QueueAccess\Structs\ApplicationResults $applicationResults
     * @param \Sabre\QueueAccess\Structs\Line[] $line
     * @param \Sabre\QueueAccess\Structs\Paragraph $paragraph
     * @param string $version
     */
    public function __construct(\Sabre\QueueAccess\Structs\ApplicationResults $applicationResults = null, array $line = array(), \Sabre\QueueAccess\Structs\Paragraph $paragraph = null, $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setLine($line)
            ->setParagraph($paragraph)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\QueueAccess\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\QueueAccess\Structs\ApplicationResults $applicationResults
     * @return \Sabre\QueueAccess\Structs\QueueAccessRS
     */
    public function setApplicationResults(\Sabre\QueueAccess\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get Line value
     * @return \Sabre\QueueAccess\Structs\Line[]|null
     */
    public function getLine()
    {
        return $this->Line;
    }
    /**
     * Set Line value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueAccess\Structs\Line[] $line
     * @return \Sabre\QueueAccess\Structs\QueueAccessRS
     */
    public function setLine(array $line = array())
    {
        $this->Line = $line;
        return $this;
    }
    /**
     * Add item to Line value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueAccess\Structs\Line $item
     * @return \Sabre\QueueAccess\Structs\QueueAccessRS
     */
    public function addToLine(\Sabre\QueueAccess\Structs\Line $item)
    {
        $this->Line[] = $item;
        return $this;
    }
    /**
     * Get Paragraph value
     * @return \Sabre\QueueAccess\Structs\Paragraph|null
     */
    public function getParagraph()
    {
        return $this->Paragraph;
    }
    /**
     * Set Paragraph value
     * @param \Sabre\QueueAccess\Structs\Paragraph $paragraph
     * @return \Sabre\QueueAccess\Structs\QueueAccessRS
     */
    public function setParagraph(\Sabre\QueueAccess\Structs\Paragraph $paragraph = null)
    {
        $this->Paragraph = $paragraph;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\QueueAccess\Structs\QueueAccessRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\QueueAccessRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
