<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueAccessRQ Structs
 * @subpackage Structs
 */
class QueueAccessRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - fixed: 2.0.8
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The Navigation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\Navigation
     */
    public $Navigation;
    /**
     * The QueueIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\QueueIdentifier
     */
    public $QueueIdentifier;
    /**
     * The Selection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 8
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\Selection[]
     */
    public $Selection;
    /**
     * The ReturnHostCommand
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReturnHostCommand;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for QueueAccessRQ
     * @uses QueueAccessRQ::setVersion()
     * @uses QueueAccessRQ::setNavigation()
     * @uses QueueAccessRQ::setQueueIdentifier()
     * @uses QueueAccessRQ::setSelection()
     * @uses QueueAccessRQ::setReturnHostCommand()
     * @uses QueueAccessRQ::setTimeStamp()
     * @param string $version
     * @param \Sabre\QueueAccess\Structs\Navigation $navigation
     * @param \Sabre\QueueAccess\Structs\QueueIdentifier $queueIdentifier
     * @param \Sabre\QueueAccess\Structs\Selection[] $selection
     * @param bool $returnHostCommand
     * @param string $timeStamp
     */
    public function __construct($version = null, \Sabre\QueueAccess\Structs\Navigation $navigation = null, \Sabre\QueueAccess\Structs\QueueIdentifier $queueIdentifier = null, array $selection = array(), $returnHostCommand = null, $timeStamp = null)
    {
        $this
            ->setVersion($version)
            ->setNavigation($navigation)
            ->setQueueIdentifier($queueIdentifier)
            ->setSelection($selection)
            ->setReturnHostCommand($returnHostCommand)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Navigation value
     * @return \Sabre\QueueAccess\Structs\Navigation|null
     */
    public function getNavigation()
    {
        return $this->Navigation;
    }
    /**
     * Set Navigation value
     * @param \Sabre\QueueAccess\Structs\Navigation $navigation
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public function setNavigation(\Sabre\QueueAccess\Structs\Navigation $navigation = null)
    {
        $this->Navigation = $navigation;
        return $this;
    }
    /**
     * Get QueueIdentifier value
     * @return \Sabre\QueueAccess\Structs\QueueIdentifier|null
     */
    public function getQueueIdentifier()
    {
        return $this->QueueIdentifier;
    }
    /**
     * Set QueueIdentifier value
     * @param \Sabre\QueueAccess\Structs\QueueIdentifier $queueIdentifier
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public function setQueueIdentifier(\Sabre\QueueAccess\Structs\QueueIdentifier $queueIdentifier = null)
    {
        $this->QueueIdentifier = $queueIdentifier;
        return $this;
    }
    /**
     * Get Selection value
     * @return \Sabre\QueueAccess\Structs\Selection[]|null
     */
    public function getSelection()
    {
        return $this->Selection;
    }
    /**
     * Set Selection value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueAccess\Structs\Selection[] $selection
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public function setSelection(array $selection = array())
    {
        $this->Selection = $selection;
        return $this;
    }
    /**
     * Add item to Selection value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueAccess\Structs\Selection $item
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public function addToSelection(\Sabre\QueueAccess\Structs\Selection $item)
    {
        $this->Selection[] = $item;
        return $this;
    }
    /**
     * Get ReturnHostCommand value
     * @return bool|null
     */
    public function getReturnHostCommand()
    {
        return $this->ReturnHostCommand;
    }
    /**
     * Set ReturnHostCommand value
     * @param bool $returnHostCommand
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public function setReturnHostCommand($returnHostCommand = null)
    {
        $this->ReturnHostCommand = $returnHostCommand;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\QueueAccessRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
