<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Line Structs
 * @subpackage Structs
 */
class Line extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Group;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\POS
     */
    public $POS;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\UniqueID
     */
    public $UniqueID;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * Constructor method for Line
     * @uses Line::setDateTime()
     * @uses Line::setGroup()
     * @uses Line::setPOS()
     * @uses Line::setUniqueID()
     * @uses Line::setNumber()
     * @param string $dateTime
     * @param string $group
     * @param \Sabre\QueueAccess\Structs\POS $pOS
     * @param \Sabre\QueueAccess\Structs\UniqueID $uniqueID
     * @param string $number
     */
    public function __construct($dateTime = null, $group = null, \Sabre\QueueAccess\Structs\POS $pOS = null, \Sabre\QueueAccess\Structs\UniqueID $uniqueID = null, $number = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setGroup($group)
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setNumber($number);
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \Sabre\QueueAccess\Structs\Line
     */
    public function setDateTime($dateTime = null)
    {
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param string $group
     * @return \Sabre\QueueAccess\Structs\Line
     */
    public function setGroup($group = null)
    {
        $this->Group = $group;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\QueueAccess\Structs\POS|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\QueueAccess\Structs\POS $pOS
     * @return \Sabre\QueueAccess\Structs\Line
     */
    public function setPOS(\Sabre\QueueAccess\Structs\POS $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \Sabre\QueueAccess\Structs\UniqueID|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \Sabre\QueueAccess\Structs\UniqueID $uniqueID
     * @return \Sabre\QueueAccess\Structs\Line
     */
    public function setUniqueID(\Sabre\QueueAccess\Structs\UniqueID $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\QueueAccess\Structs\Line
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\Line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
