<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemSpecificResults Structs
 * @subpackage Structs
 */
class SystemSpecificResults extends AbstractStructBase
{
    /**
     * The HostCommand
     * Meta informations extracted from the WSDL
     * - documentation: Host system command run to create this result.
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\HostCommand
     */
    public $HostCommand;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Application specific code and Message. A textual description to provide more information about the specific condition, warning or error with code attribute as numeric value.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\Message_Condition[]
     */
    public $Message;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - documentation: An abbreviated version of the error in textual format. | Same as STL Text.Short - A field of text characters and no other constraints.
     * - minOccurs: 0
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $ShortText;
    /**
     * The Element
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one
     * tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing]. | Same as STL Text.Long - A field text characters and no other constraints.
     * - minOccurs: 0
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $Element;
    /**
     * The RecordID
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s)
     * associated with that transaction.
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $RecordID;
    /**
     * The DocURL
     * Meta informations extracted from the WSDL
     * - documentation: If present, this attribute refers to an online description of the error that occurred.
     * - minOccurs: 0
     * @var string
     */
    public $DocURL;
    /**
     * The timeStamp
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for SystemSpecificResults
     * @uses SystemSpecificResults::setHostCommand()
     * @uses SystemSpecificResults::setMessage()
     * @uses SystemSpecificResults::setShortText()
     * @uses SystemSpecificResults::setElement()
     * @uses SystemSpecificResults::setRecordID()
     * @uses SystemSpecificResults::setDocURL()
     * @uses SystemSpecificResults::setTimeStamp()
     * @param \Sabre\QueueAccess\Structs\HostCommand $hostCommand
     * @param \Sabre\QueueAccess\Structs\Message_Condition[] $message
     * @param string $shortText
     * @param string $element
     * @param string $recordID
     * @param string $docURL
     * @param string $timeStamp
     */
    public function __construct(\Sabre\QueueAccess\Structs\HostCommand $hostCommand = null, array $message = array(), $shortText = null, $element = null, $recordID = null, $docURL = null, $timeStamp = null)
    {
        $this
            ->setHostCommand($hostCommand)
            ->setMessage($message)
            ->setShortText($shortText)
            ->setElement($element)
            ->setRecordID($recordID)
            ->setDocURL($docURL)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get HostCommand value
     * @return \Sabre\QueueAccess\Structs\HostCommand|null
     */
    public function getHostCommand()
    {
        return $this->HostCommand;
    }
    /**
     * Set HostCommand value
     * @param \Sabre\QueueAccess\Structs\HostCommand $hostCommand
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function setHostCommand(\Sabre\QueueAccess\Structs\HostCommand $hostCommand = null)
    {
        $this->HostCommand = $hostCommand;
        return $this;
    }
    /**
     * Get Message value
     * @return \Sabre\QueueAccess\Structs\Message_Condition[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueAccess\Structs\Message_Condition[] $message
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function setMessage(array $message = array())
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \Sabre\QueueAccess\Structs\Message_Condition $item
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function addToMessage(\Sabre\QueueAccess\Structs\Message_Condition $item)
    {
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Element value
     * @return string|null
     */
    public function getElement()
    {
        return $this->Element;
    }
    /**
     * Set Element value
     * @param string $element
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function setElement($element = null)
    {
        $this->Element = $element;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function setRecordID($recordID = null)
    {
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get DocURL value
     * @return string|null
     */
    public function getDocURL()
    {
        return $this->DocURL;
    }
    /**
     * Set DocURL value
     * @param string $docURL
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function setDocURL($docURL = null)
    {
        $this->DocURL = $docURL;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\SystemSpecificResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
