<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security Structs
 * Meta informations extracted from the WSDL
 * - Prefix: wsse
 * - documentation: Header records no longer contain user credentials (username/password) as these are needed only for SessionCreateRQ in which the credentials should be in the payload.
 * - type: Security
 * @subpackage Structs
 */
class Security extends AbstractStructBase
{
    /**
     * The SecurityToken
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Long - A field text characters and no other constraints.
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $SecurityToken;
    /**
     * The UsernameToken
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\UsernameToken
     */
    public $UsernameToken;
    /**
     * The SabreAth
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $SabreAth;
    /**
     * The BinarySecurityToken
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $BinarySecurityToken;
    /**
     * Constructor method for Security
     * @uses Security::setSecurityToken()
     * @uses Security::setUsernameToken()
     * @uses Security::setSabreAth()
     * @uses Security::setBinarySecurityToken()
     * @param string $securityToken
     * @param \Sabre\QueueAccess\Structs\UsernameToken $usernameToken
     * @param string $sabreAth
     * @param string $binarySecurityToken
     */
    public function __construct($securityToken = null, \Sabre\QueueAccess\Structs\UsernameToken $usernameToken = null, $sabreAth = null, $binarySecurityToken = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setUsernameToken($usernameToken)
            ->setSabreAth($sabreAth)
            ->setBinarySecurityToken($binarySecurityToken);
    }
    /**
     * Get SecurityToken value
     * @return string|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * Set SecurityToken value
     * @param string $securityToken
     * @return \Sabre\QueueAccess\Structs\Security
     */
    public function setSecurityToken($securityToken = null)
    {
        $this->SecurityToken = $securityToken;
        return $this;
    }
    /**
     * Get UsernameToken value
     * @return \Sabre\QueueAccess\Structs\UsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \Sabre\QueueAccess\Structs\UsernameToken $usernameToken
     * @return \Sabre\QueueAccess\Structs\Security
     */
    public function setUsernameToken(\Sabre\QueueAccess\Structs\UsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get SabreAth value
     * @return string|null
     */
    public function getSabreAth()
    {
        return $this->SabreAth;
    }
    /**
     * Set SabreAth value
     * @param string $sabreAth
     * @return \Sabre\QueueAccess\Structs\Security
     */
    public function setSabreAth($sabreAth = null)
    {
        $this->SabreAth = $sabreAth;
        return $this;
    }
    /**
     * Get BinarySecurityToken value
     * @return string|null
     */
    public function getBinarySecurityToken()
    {
        return $this->BinarySecurityToken;
    }
    /**
     * Set BinarySecurityToken value
     * @param string $binarySecurityToken
     * @return \Sabre\QueueAccess\Structs\Security
     */
    public function setBinarySecurityToken($binarySecurityToken = null)
    {
        $this->BinarySecurityToken = $binarySecurityToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\Security
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
