<?php

namespace Sabre\QueueAccess\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Navigation Structs
 * @subpackage Structs
 */
class Navigation extends AbstractStructBase
{
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\QueueAccess\Structs\Direction
     */
    public $Direction;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Action;
    /**
     * Constructor method for Navigation
     * @uses Navigation::setDirection()
     * @uses Navigation::setAction()
     * @param \Sabre\QueueAccess\Structs\Direction $direction
     * @param string $action
     */
    public function __construct(\Sabre\QueueAccess\Structs\Direction $direction = null, $action = null)
    {
        $this
            ->setDirection($direction)
            ->setAction($action);
    }
    /**
     * Get Direction value
     * @return \Sabre\QueueAccess\Structs\Direction|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param \Sabre\QueueAccess\Structs\Direction $direction
     * @return \Sabre\QueueAccess\Structs\Navigation
     */
    public function setDirection(\Sabre\QueueAccess\Structs\Direction $direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \Sabre\QueueAccess\Structs\Navigation
     */
    public function setAction($action = null)
    {
        $this->Action = $action;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\QueueAccess\Structs\Navigation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
