<?php

namespace Sabre\OTACancel\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_CancelRS Structs
 * @subpackage Structs
 */
class OTA_CancelRS extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - ref: stl:ApplicationResults
     * @var \Sabre\OTACancel\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for OTA_CancelRS
     * @uses OTA_CancelRS::setApplicationResults()
     * @uses OTA_CancelRS::setText()
     * @uses OTA_CancelRS::setVersion()
     * @param \Sabre\OTACancel\Structs\ApplicationResults $applicationResults
     * @param string[] $text
     * @param string $version
     */
    public function __construct(\Sabre\OTACancel\Structs\ApplicationResults $applicationResults = null, array $text = array(), $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setText($text)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\OTACancel\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\OTACancel\Structs\ApplicationResults $applicationResults
     * @return \Sabre\OTACancel\Structs\OTA_CancelRS
     */
    public function setApplicationResults(\Sabre\OTACancel\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\OTACancel\Structs\OTA_CancelRS
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTACancel\Structs\OTA_CancelRS
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\OTACancel\Structs\OTA_CancelRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTACancel\Structs\OTA_CancelRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
