<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/OTA_CancelLLS2.0.2RQ.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/OTA_CancelLLS2.0.2RQ.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\OTACancel\ClassMap::get(),
);
/**
 * Samples for OTAC ServiceType
 */
$oTAC = new \Sabre\OTACancel\Services\OTAC($options);
$oTAC->setSoapHeaderMessageHeader(new \Sabre\OTACancel\Structs\MessageHeader());
$oTAC->setSoapHeaderSecurity(new \Sabre\OTACancel\Structs\Security());
/**
 * Sample call for OTA_CancelRQ operation/method
 */
if ($oTAC->OTA_CancelRQ(new \Sabre\OTACancel\Structs\OTA_CancelRQ()) !== false) {
    print_r($oTAC->getResult());
} else {
    print_r($oTAC->getLastError());
}
