<?php

namespace Sabre\OTACancel\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Schema Structs
 * @subpackage Structs
 */
class Schema extends AbstractStructBase
{
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $location;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Schema
     * @uses Schema::setLocation()
     * @uses Schema::setVersion()
     * @param string $location
     * @param string $version
     */
    public function __construct($location = null, $version = null)
    {
        $this
            ->setLocation($location)
            ->setVersion($version);
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \Sabre\OTACancel\Structs\Schema
     */
    public function setLocation($location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\OTACancel\Structs\Schema
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTACancel\Structs\Schema
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
