<?php

namespace Sabre\OTACancel\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_CancelRQ Structs
 * @subpackage Structs
 */
class OTA_CancelRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - fixed: 2.0.2
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\OTACancel\Structs\Segment[]
     */
    public $Segment;
    /**
     * The NumResponses
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NumResponses;
    /**
     * The ReturnHostCommand
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReturnHostCommand;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for OTA_CancelRQ
     * @uses OTA_CancelRQ::setVersion()
     * @uses OTA_CancelRQ::setSegment()
     * @uses OTA_CancelRQ::setNumResponses()
     * @uses OTA_CancelRQ::setReturnHostCommand()
     * @uses OTA_CancelRQ::setTimeStamp()
     * @param string $version
     * @param \Sabre\OTACancel\Structs\Segment[] $segment
     * @param string $numResponses
     * @param bool $returnHostCommand
     * @param string $timeStamp
     */
    public function __construct($version = null, array $segment = array(), $numResponses = null, $returnHostCommand = null, $timeStamp = null)
    {
        $this
            ->setVersion($version)
            ->setSegment($segment)
            ->setNumResponses($numResponses)
            ->setReturnHostCommand($returnHostCommand)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\OTACancel\Structs\OTA_CancelRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\OTACancel\Structs\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTACancel\Structs\Segment[] $segment
     * @return \Sabre\OTACancel\Structs\OTA_CancelRQ
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTACancel\Structs\Segment $item
     * @return \Sabre\OTACancel\Structs\OTA_CancelRQ
     */
    public function addToSegment(\Sabre\OTACancel\Structs\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Get NumResponses value
     * @return string|null
     */
    public function getNumResponses()
    {
        return $this->NumResponses;
    }
    /**
     * Set NumResponses value
     * @param string $numResponses
     * @return \Sabre\OTACancel\Structs\OTA_CancelRQ
     */
    public function setNumResponses($numResponses = null)
    {
        $this->NumResponses = $numResponses;
        return $this;
    }
    /**
     * Get ReturnHostCommand value
     * @return bool|null
     */
    public function getReturnHostCommand()
    {
        return $this->ReturnHostCommand;
    }
    /**
     * Set ReturnHostCommand value
     * @param bool $returnHostCommand
     * @return \Sabre\OTACancel\Structs\OTA_CancelRQ
     */
    public function setReturnHostCommand($returnHostCommand = null)
    {
        $this->ReturnHostCommand = $returnHostCommand;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\OTACancel\Structs\OTA_CancelRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTACancel\Structs\OTA_CancelRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
