<?php

namespace Sabre\RulesFromPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Header Structs
 * Meta informations extracted from the WSDL
 * - type: tns:Header
 * @subpackage Structs
 */
class Header extends AbstractStructBase
{
    /**
     * The Line
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\RulesFromPrice\Structs\Line[]
     */
    public $Line;
    /**
     * The ParsedData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\RulesFromPrice\Structs\ParsedData
     */
    public $ParsedData;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for Header
     * @uses Header::setLine()
     * @uses Header::setParsedData()
     * @uses Header::setAny()
     * @param \Sabre\RulesFromPrice\Structs\Line[] $line
     * @param \Sabre\RulesFromPrice\Structs\ParsedData $parsedData
     * @param \DOMDocument $any
     */
    public function __construct(array $line = array(), \Sabre\RulesFromPrice\Structs\ParsedData $parsedData = null, \DOMDocument $any = null)
    {
        $this
            ->setLine($line)
            ->setParsedData($parsedData)
            ->setAny($any);
    }
    /**
     * Get Line value
     * @return \Sabre\RulesFromPrice\Structs\Line[]|null
     */
    public function getLine()
    {
        return $this->Line;
    }
    /**
     * Set Line value
     * @throws \InvalidArgumentException
     * @param \Sabre\RulesFromPrice\Structs\Line[] $line
     * @return \Sabre\RulesFromPrice\Structs\Header
     */
    public function setLine(array $line = array())
    {
        $this->Line = $line;
        return $this;
    }
    /**
     * Add item to Line value
     * @throws \InvalidArgumentException
     * @param \Sabre\RulesFromPrice\Structs\Line $item
     * @return \Sabre\RulesFromPrice\Structs\Header
     */
    public function addToLine(\Sabre\RulesFromPrice\Structs\Line $item)
    {
        $this->Line[] = $item;
        return $this;
    }
    /**
     * Get ParsedData value
     * @return \Sabre\RulesFromPrice\Structs\ParsedData|null
     */
    public function getParsedData()
    {
        return $this->ParsedData;
    }
    /**
     * Set ParsedData value
     * @param \Sabre\RulesFromPrice\Structs\ParsedData $parsedData
     * @return \Sabre\RulesFromPrice\Structs\Header
     */
    public function setParsedData(\Sabre\RulesFromPrice\Structs\ParsedData $parsedData = null)
    {
        $this->ParsedData = $parsedData;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\RulesFromPrice\Structs\Header::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\RulesFromPrice\Structs\Header
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\RulesFromPrice\Structs\Header
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
