<?php

namespace Sabre\RulesFromPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyLine Structs
 * @subpackage Structs
 */
class CurrencyLine extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Discontinue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Discontinue;
    /**
     * The Effective
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $Effective;
    /**
     * The FareClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FareClass;
    /**
     * The RoutingNumberOrMPM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoutingNumberOrMPM;
    /**
     * The TariffDescriptionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TariffDescriptionNumber;
    /**
     * Constructor method for CurrencyLine
     * @uses CurrencyLine::setAmount()
     * @uses CurrencyLine::setCurrencyCode()
     * @uses CurrencyLine::setDiscontinue()
     * @uses CurrencyLine::setEffective()
     * @uses CurrencyLine::setFareClass()
     * @uses CurrencyLine::setRoutingNumberOrMPM()
     * @uses CurrencyLine::setTariffDescriptionNumber()
     * @param string $amount
     * @param string $currencyCode
     * @param string $discontinue
     * @param string $effective
     * @param string $fareClass
     * @param string $routingNumberOrMPM
     * @param string $tariffDescriptionNumber
     */
    public function __construct($amount = null, $currencyCode = null, $discontinue = null, $effective = null, $fareClass = null, $routingNumberOrMPM = null, $tariffDescriptionNumber = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDiscontinue($discontinue)
            ->setEffective($effective)
            ->setFareClass($fareClass)
            ->setRoutingNumberOrMPM($routingNumberOrMPM)
            ->setTariffDescriptionNumber($tariffDescriptionNumber);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Discontinue value
     * @return string|null
     */
    public function getDiscontinue()
    {
        return $this->Discontinue;
    }
    /**
     * Set Discontinue value
     * @param string $discontinue
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public function setDiscontinue($discontinue = null)
    {
        $this->Discontinue = $discontinue;
        return $this;
    }
    /**
     * Get Effective value
     * @return string|null
     */
    public function getEffective()
    {
        return $this->Effective;
    }
    /**
     * Set Effective value
     * @param string $effective
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public function setEffective($effective = null)
    {
        $this->Effective = $effective;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public function setFareClass($fareClass = null)
    {
        $this->FareClass = $fareClass;
        return $this;
    }
    /**
     * Get RoutingNumberOrMPM value
     * @return string|null
     */
    public function getRoutingNumberOrMPM()
    {
        return $this->RoutingNumberOrMPM;
    }
    /**
     * Set RoutingNumberOrMPM value
     * @param string $routingNumberOrMPM
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public function setRoutingNumberOrMPM($routingNumberOrMPM = null)
    {
        $this->RoutingNumberOrMPM = $routingNumberOrMPM;
        return $this;
    }
    /**
     * Get TariffDescriptionNumber value
     * @return string|null
     */
    public function getTariffDescriptionNumber()
    {
        return $this->TariffDescriptionNumber;
    }
    /**
     * Set TariffDescriptionNumber value
     * @param string $tariffDescriptionNumber
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public function setTariffDescriptionNumber($tariffDescriptionNumber = null)
    {
        $this->TariffDescriptionNumber = $tariffDescriptionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\RulesFromPrice\Structs\CurrencyLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
