<?php

namespace Sabre\RulesFromPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rules Structs
 * @subpackage Structs
 */
class Rules extends AbstractStructBase
{
    /**
     * The Paragraph
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\RulesFromPrice\Structs\Paragraph[]
     */
    public $Paragraph;
    /**
     * Constructor method for Rules
     * @uses Rules::setParagraph()
     * @param \Sabre\RulesFromPrice\Structs\Paragraph[] $paragraph
     */
    public function __construct(array $paragraph = array())
    {
        $this
            ->setParagraph($paragraph);
    }
    /**
     * Get Paragraph value
     * @return \Sabre\RulesFromPrice\Structs\Paragraph[]|null
     */
    public function getParagraph()
    {
        return $this->Paragraph;
    }
    /**
     * Set Paragraph value
     * @throws \InvalidArgumentException
     * @param \Sabre\RulesFromPrice\Structs\Paragraph[] $paragraph
     * @return \Sabre\RulesFromPrice\Structs\Rules
     */
    public function setParagraph(array $paragraph = array())
    {
        $this->Paragraph = $paragraph;
        return $this;
    }
    /**
     * Add item to Paragraph value
     * @throws \InvalidArgumentException
     * @param \Sabre\RulesFromPrice\Structs\Paragraph $item
     * @return \Sabre\RulesFromPrice\Structs\Rules
     */
    public function addToParagraph(\Sabre\RulesFromPrice\Structs\Paragraph $item)
    {
        $this->Paragraph[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\RulesFromPrice\Structs\Rules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
