<?php

namespace Sabre\RulesFromPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Paragraph Structs
 * @subpackage Structs
 */
class Paragraph extends AbstractStructBase
{
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * Constructor method for Paragraph
     * @uses Paragraph::setText()
     * @uses Paragraph::setRPH()
     * @uses Paragraph::setTitle()
     * @param string $text
     * @param string $rPH
     * @param string $title
     */
    public function __construct($text = null, $rPH = null, $title = null)
    {
        $this
            ->setText($text)
            ->setRPH($rPH)
            ->setTitle($title);
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\RulesFromPrice\Structs\Paragraph
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\RulesFromPrice\Structs\Paragraph
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \Sabre\RulesFromPrice\Structs\Paragraph
     */
    public function setTitle($title = null)
    {
        $this->Title = $title;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\RulesFromPrice\Structs\Paragraph
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
