<?php

namespace Sabre\RulesFromPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passenger Structs
 * @subpackage Structs
 */
class Passenger extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The TypeNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TypeNumber;
    /**
     * Constructor method for Passenger
     * @uses Passenger::setCode()
     * @uses Passenger::setTypeNumber()
     * @param string $code
     * @param string $typeNumber
     */
    public function __construct($code = null, $typeNumber = null)
    {
        $this
            ->setCode($code)
            ->setTypeNumber($typeNumber);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\RulesFromPrice\Structs\Passenger
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get TypeNumber value
     * @return string|null
     */
    public function getTypeNumber()
    {
        return $this->TypeNumber;
    }
    /**
     * Set TypeNumber value
     * @param string $typeNumber
     * @return \Sabre\RulesFromPrice\Structs\Passenger
     */
    public function setTypeNumber($typeNumber = null)
    {
        $this->TypeNumber = $typeNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\RulesFromPrice\Structs\Passenger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
