<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/VoidTicketLLS2.0.2RQ.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/VoidTicketLLS2.0.2RQ.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\VoidTicket\ClassMap::get(),
);
/**
 * Samples for Void ServiceType
 */
$void = new \Sabre\VoidTicket\Services\Void($options);
$void->setSoapHeaderMessageHeader(new \Sabre\VoidTicket\Structs\MessageHeader());
$void->setSoapHeaderSecurity(new \Sabre\VoidTicket\Structs\Security());
/**
 * Sample call for VoidTicketRQ operation/method
 */
if ($void->VoidTicketRQ(new \Sabre\VoidTicket\Structs\VoidTicketRQ()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
