<?php

namespace Sabre\VoidTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoidTicketRQ Structs
 * @subpackage Structs
 */
class VoidTicketRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - fixed: 2.0.2
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The Ticketing
     * @var \Sabre\VoidTicket\Structs\Ticketing
     */
    public $Ticketing;
    /**
     * The ReturnHostCommand
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReturnHostCommand;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for VoidTicketRQ
     * @uses VoidTicketRQ::setVersion()
     * @uses VoidTicketRQ::setTicketing()
     * @uses VoidTicketRQ::setReturnHostCommand()
     * @uses VoidTicketRQ::setTimeStamp()
     * @param string $version
     * @param \Sabre\VoidTicket\Structs\Ticketing $ticketing
     * @param bool $returnHostCommand
     * @param string $timeStamp
     */
    public function __construct($version = null, \Sabre\VoidTicket\Structs\Ticketing $ticketing = null, $returnHostCommand = null, $timeStamp = null)
    {
        $this
            ->setVersion($version)
            ->setTicketing($ticketing)
            ->setReturnHostCommand($returnHostCommand)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\VoidTicket\Structs\VoidTicketRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \Sabre\VoidTicket\Structs\Ticketing|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @param \Sabre\VoidTicket\Structs\Ticketing $ticketing
     * @return \Sabre\VoidTicket\Structs\VoidTicketRQ
     */
    public function setTicketing(\Sabre\VoidTicket\Structs\Ticketing $ticketing = null)
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Get ReturnHostCommand value
     * @return bool|null
     */
    public function getReturnHostCommand()
    {
        return $this->ReturnHostCommand;
    }
    /**
     * Set ReturnHostCommand value
     * @param bool $returnHostCommand
     * @return \Sabre\VoidTicket\Structs\VoidTicketRQ
     */
    public function setReturnHostCommand($returnHostCommand = null)
    {
        $this->ReturnHostCommand = $returnHostCommand;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\VoidTicket\Structs\VoidTicketRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\VoidTicket\Structs\VoidTicketRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
