<?php

namespace Sabre\VoidTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for STL_Payload Structs
 * Meta informations extracted from the WSDL
 * - documentation: Create all message root elements as member of the substitution group with the element as the head. Global message types must be defined as an extension of the STL_Payload type. | All message roots should be created as an extension of
 * this base type. Global message elements must declare they are a member of the STL_Payload substitution group. This type may be used when an empty payload is needed for error handling.
 * - type: STL_Payload
 * @subpackage Structs
 */
abstract class STL_Payload extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ApplicationResults
     * @var \Sabre\VoidTicket\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The version
     * @var string
     */
    public $version;
    /**
     * Constructor method for STL_Payload
     * @uses STL_Payload::setApplicationResults()
     * @uses STL_Payload::setVersion()
     * @param \Sabre\VoidTicket\Structs\ApplicationResults $applicationResults
     * @param string $version
     */
    public function __construct(\Sabre\VoidTicket\Structs\ApplicationResults $applicationResults = null, $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\VoidTicket\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\VoidTicket\Structs\ApplicationResults $applicationResults
     * @return \Sabre\VoidTicket\Structs\STL_Payload
     */
    public function setApplicationResults(\Sabre\VoidTicket\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\VoidTicket\Structs\STL_Payload
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\VoidTicket\Structs\STL_Payload
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
