<?php

namespace Sabre\VoidTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Diagnostics Structs
 * Meta informations extracted from the WSDL
 * - type: Diagnostics
 * @subpackage Structs
 */
class Diagnostics extends AbstractStructBase
{
    /**
     * The Level
     * Meta informations extracted from the WSDL
     * - documentation: Describes the level of diagnostic data requested or provided.
     * - minOccurs: 0
     * @var string
     */
    public $Level;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Block of diagnostic data included in request or returned in the response. | Same as STL Text.Long - A field text characters and no other constraints.
     * - minOccurs: 0
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $Data;
    /**
     * The Diagnostic
     * Meta informations extracted from the WSDL
     * - documentation: Diagnostic data. Must be defined in a differrent namespace as the header.
     * - minOccurs: 0
     * @var \Sabre\VoidTicket\Structs\DiagnosticResults
     */
    public $Diagnostic;
    /**
     * Constructor method for Diagnostics
     * @uses Diagnostics::setLevel()
     * @uses Diagnostics::setData()
     * @uses Diagnostics::setDiagnostic()
     * @param string $level
     * @param string $data
     * @param \Sabre\VoidTicket\Structs\DiagnosticResults $diagnostic
     */
    public function __construct($level = null, $data = null, \Sabre\VoidTicket\Structs\DiagnosticResults $diagnostic = null)
    {
        $this
            ->setLevel($level)
            ->setData($data)
            ->setDiagnostic($diagnostic);
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \Sabre\VoidTicket\Enums\DiagnosticLevels::valueIsValid()
     * @uses \Sabre\VoidTicket\Enums\DiagnosticLevels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \Sabre\VoidTicket\Structs\Diagnostics
     */
    public function setLevel($level = null)
    {
        $this->Level = $level;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Sabre\VoidTicket\Structs\Diagnostics
     */
    public function setData($data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Diagnostic value
     * @return \Sabre\VoidTicket\Structs\DiagnosticResults|null
     */
    public function getDiagnostic()
    {
        return $this->Diagnostic;
    }
    /**
     * Set Diagnostic value
     * @param \Sabre\VoidTicket\Structs\DiagnosticResults $diagnostic
     * @return \Sabre\VoidTicket\Structs\Diagnostics
     */
    public function setDiagnostic(\Sabre\VoidTicket\Structs\DiagnosticResults $diagnostic = null)
    {
        $this->Diagnostic = $diagnostic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\VoidTicket\Structs\Diagnostics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
