<?php

namespace Sabre\VoidTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoidTicketRS Structs
 * @subpackage Structs
 */
class VoidTicketRS extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - ref: stl:ApplicationResults
     * @var \Sabre\VoidTicket\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for VoidTicketRS
     * @uses VoidTicketRS::setApplicationResults()
     * @uses VoidTicketRS::setText()
     * @uses VoidTicketRS::setVersion()
     * @param \Sabre\VoidTicket\Structs\ApplicationResults $applicationResults
     * @param string[] $text
     * @param string $version
     */
    public function __construct(\Sabre\VoidTicket\Structs\ApplicationResults $applicationResults = null, array $text = array(), $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setText($text)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\VoidTicket\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\VoidTicket\Structs\ApplicationResults $applicationResults
     * @return \Sabre\VoidTicket\Structs\VoidTicketRS
     */
    public function setApplicationResults(\Sabre\VoidTicket\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\VoidTicket\Structs\VoidTicketRS
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\VoidTicket\Structs\VoidTicketRS
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\VoidTicket\Structs\VoidTicketRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\VoidTicket\Structs\VoidTicketRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
