<?php

namespace Sabre\VoidTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignedInfoType Structs
 * @subpackage Structs
 */
class SignedInfoType extends AbstractStructBase
{
    /**
     * The CanonicalizationMethod
     * Meta informations extracted from the WSDL
     * - ref: ds:CanonicalizationMethod
     * @var \Sabre\VoidTicket\Structs\CanonicalizationMethodType
     */
    public $CanonicalizationMethod;
    /**
     * The SignatureMethod
     * Meta informations extracted from the WSDL
     * - ref: ds:SignatureMethod
     * @var \Sabre\VoidTicket\Structs\SignatureMethodType
     */
    public $SignatureMethod;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:Reference
     * @var \Sabre\VoidTicket\Structs\ReferenceType[]
     */
    public $Reference;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignedInfoType
     * @uses SignedInfoType::setCanonicalizationMethod()
     * @uses SignedInfoType::setSignatureMethod()
     * @uses SignedInfoType::setReference()
     * @uses SignedInfoType::setId()
     * @param \Sabre\VoidTicket\Structs\CanonicalizationMethodType $canonicalizationMethod
     * @param \Sabre\VoidTicket\Structs\SignatureMethodType $signatureMethod
     * @param \Sabre\VoidTicket\Structs\ReferenceType[] $reference
     * @param string $id
     */
    public function __construct(\Sabre\VoidTicket\Structs\CanonicalizationMethodType $canonicalizationMethod = null, \Sabre\VoidTicket\Structs\SignatureMethodType $signatureMethod = null, array $reference = array(), $id = null)
    {
        $this
            ->setCanonicalizationMethod($canonicalizationMethod)
            ->setSignatureMethod($signatureMethod)
            ->setReference($reference)
            ->setId($id);
    }
    /**
     * Get CanonicalizationMethod value
     * @return \Sabre\VoidTicket\Structs\CanonicalizationMethodType|null
     */
    public function getCanonicalizationMethod()
    {
        return $this->CanonicalizationMethod;
    }
    /**
     * Set CanonicalizationMethod value
     * @param \Sabre\VoidTicket\Structs\CanonicalizationMethodType $canonicalizationMethod
     * @return \Sabre\VoidTicket\Structs\SignedInfoType
     */
    public function setCanonicalizationMethod(\Sabre\VoidTicket\Structs\CanonicalizationMethodType $canonicalizationMethod = null)
    {
        $this->CanonicalizationMethod = $canonicalizationMethod;
        return $this;
    }
    /**
     * Get SignatureMethod value
     * @return \Sabre\VoidTicket\Structs\SignatureMethodType|null
     */
    public function getSignatureMethod()
    {
        return $this->SignatureMethod;
    }
    /**
     * Set SignatureMethod value
     * @param \Sabre\VoidTicket\Structs\SignatureMethodType $signatureMethod
     * @return \Sabre\VoidTicket\Structs\SignedInfoType
     */
    public function setSignatureMethod(\Sabre\VoidTicket\Structs\SignatureMethodType $signatureMethod = null)
    {
        $this->SignatureMethod = $signatureMethod;
        return $this;
    }
    /**
     * Get Reference value
     * @return \Sabre\VoidTicket\Structs\ReferenceType[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param \Sabre\VoidTicket\Structs\ReferenceType[] $reference
     * @return \Sabre\VoidTicket\Structs\SignedInfoType
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \Sabre\VoidTicket\Structs\ReferenceType $item
     * @return \Sabre\VoidTicket\Structs\SignedInfoType
     */
    public function addToReference(\Sabre\VoidTicket\Structs\ReferenceType $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\VoidTicket\Structs\SignedInfoType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\VoidTicket\Structs\SignedInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
