<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidityDates Structs
 * @subpackage Structs
 */
class ValidityDates extends AbstractStructBase
{
    /**
     * The NotValidAfter
     * Meta informations extracted from the WSDL
     * - documentation: "NotValidAfter" is used to return the ending validity date associated with the particular flight segment. "NotValidAfter" follows this format: MM:DD
     * - minOccurs: 0
     * @var string
     */
    public $NotValidAfter;
    /**
     * The NotValidBefore
     * Meta informations extracted from the WSDL
     * - documentation: "NotValidBefore" is used to return the beginning validity date associated with the particular flight segment. "NotValidBefore" follows this format: MM:DD
     * - minOccurs: 0
     * @var string
     */
    public $NotValidBefore;
    /**
     * Constructor method for ValidityDates
     * @uses ValidityDates::setNotValidAfter()
     * @uses ValidityDates::setNotValidBefore()
     * @param string $notValidAfter
     * @param string $notValidBefore
     */
    public function __construct($notValidAfter = null, $notValidBefore = null)
    {
        $this
            ->setNotValidAfter($notValidAfter)
            ->setNotValidBefore($notValidBefore);
    }
    /**
     * Get NotValidAfter value
     * @return string|null
     */
    public function getNotValidAfter()
    {
        return $this->NotValidAfter;
    }
    /**
     * Set NotValidAfter value
     * @param string $notValidAfter
     * @return \Sabre\PassengerDetailsRQ\Structs\ValidityDates
     */
    public function setNotValidAfter($notValidAfter = null)
    {
        $this->NotValidAfter = $notValidAfter;
        return $this;
    }
    /**
     * Get NotValidBefore value
     * @return string|null
     */
    public function getNotValidBefore()
    {
        return $this->NotValidBefore;
    }
    /**
     * Set NotValidBefore value
     * @param string $notValidBefore
     * @return \Sabre\PassengerDetailsRQ\Structs\ValidityDates
     */
    public function setNotValidBefore($notValidBefore = null)
    {
        $this->NotValidBefore = $notValidBefore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ValidityDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
