<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingDocument Structs
 * @subpackage Structs
 */
class TicketingDocument extends AbstractStructBase
{
    /**
     * The ServiceCoupon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ServiceCoupon[]
     */
    public $ServiceCoupon;
    /**
     * The accountingCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $accountingCode;
    /**
     * The checkDigit
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $checkDigit;
    /**
     * The formNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $formNumber;
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The serialNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $serialNumber;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for TicketingDocument
     * @uses TicketingDocument::setServiceCoupon()
     * @uses TicketingDocument::setAccountingCode()
     * @uses TicketingDocument::setCheckDigit()
     * @uses TicketingDocument::setFormNumber()
     * @uses TicketingDocument::setNumber()
     * @uses TicketingDocument::setSerialNumber()
     * @uses TicketingDocument::setType()
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceCoupon[] $serviceCoupon
     * @param string $accountingCode
     * @param string $checkDigit
     * @param string $formNumber
     * @param string $number
     * @param string $serialNumber
     * @param string $type
     */
    public function __construct(array $serviceCoupon = array(), $accountingCode = null, $checkDigit = null, $formNumber = null, $number = null, $serialNumber = null, $type = null)
    {
        $this
            ->setServiceCoupon($serviceCoupon)
            ->setAccountingCode($accountingCode)
            ->setCheckDigit($checkDigit)
            ->setFormNumber($formNumber)
            ->setNumber($number)
            ->setSerialNumber($serialNumber)
            ->setType($type);
    }
    /**
     * Get ServiceCoupon value
     * @return \Sabre\PassengerDetailsRQ\Structs\ServiceCoupon[]|null
     */
    public function getServiceCoupon()
    {
        return $this->ServiceCoupon;
    }
    /**
     * Set ServiceCoupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceCoupon[] $serviceCoupon
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function setServiceCoupon(array $serviceCoupon = array())
    {
        $this->ServiceCoupon = $serviceCoupon;
        return $this;
    }
    /**
     * Add item to ServiceCoupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceCoupon $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function addToServiceCoupon(\Sabre\PassengerDetailsRQ\Structs\ServiceCoupon $item)
    {
        $this->ServiceCoupon[] = $item;
        return $this;
    }
    /**
     * Get accountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->accountingCode;
    }
    /**
     * Set accountingCode value
     * @param string $accountingCode
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function setAccountingCode($accountingCode = null)
    {
        $this->accountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get checkDigit value
     * @return string|null
     */
    public function getCheckDigit()
    {
        return $this->checkDigit;
    }
    /**
     * Set checkDigit value
     * @param string $checkDigit
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function setCheckDigit($checkDigit = null)
    {
        $this->checkDigit = $checkDigit;
        return $this;
    }
    /**
     * Get formNumber value
     * @return string|null
     */
    public function getFormNumber()
    {
        return $this->formNumber;
    }
    /**
     * Set formNumber value
     * @param string $formNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function setFormNumber($formNumber = null)
    {
        $this->formNumber = $formNumber;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function setNumber($number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function setSerialNumber($serialNumber = null)
    {
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
