<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateQualifierType Structs
 * @subpackage Structs
 */
class RateQualifierType extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountID;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The PromotionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PromotionCode;
    /**
     * The SpecialInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SpecialInputType[]
     */
    public $SpecialInput;
    /**
     * Constructor method for RateQualifierType
     * @uses RateQualifierType::setAccountID()
     * @uses RateQualifierType::setAccountName()
     * @uses RateQualifierType::setPromotionCode()
     * @uses RateQualifierType::setSpecialInput()
     * @param string $accountID
     * @param string $accountName
     * @param string $promotionCode
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialInputType[] $specialInput
     */
    public function __construct($accountID = null, $accountName = null, $promotionCode = null, array $specialInput = array())
    {
        $this
            ->setAccountID($accountID)
            ->setAccountName($accountName)
            ->setPromotionCode($promotionCode)
            ->setSpecialInput($specialInput);
    }
    /**
     * Get AccountID value
     * @return string|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param string $accountID
     * @return \Sabre\PassengerDetailsRQ\Structs\RateQualifierType
     */
    public function setAccountID($accountID = null)
    {
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \Sabre\PassengerDetailsRQ\Structs\RateQualifierType
     */
    public function setAccountName($accountName = null)
    {
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \Sabre\PassengerDetailsRQ\Structs\RateQualifierType
     */
    public function setPromotionCode($promotionCode = null)
    {
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get SpecialInput value
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialInputType[]|null
     */
    public function getSpecialInput()
    {
        return $this->SpecialInput;
    }
    /**
     * Set SpecialInput value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialInputType[] $specialInput
     * @return \Sabre\PassengerDetailsRQ\Structs\RateQualifierType
     */
    public function setSpecialInput(array $specialInput = array())
    {
        $this->SpecialInput = $specialInput;
        return $this;
    }
    /**
     * Add item to SpecialInput value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialInputType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\RateQualifierType
     */
    public function addToSpecialInput(\Sabre\PassengerDetailsRQ\Structs\SpecialInputType $item)
    {
        $this->SpecialInput[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\RateQualifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
