<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileInfo Structs
 * @subpackage Structs
 */
class FileInfo extends AbstractStructBase
{
    /**
     * The File
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\File[]
     */
    public $File;
    /**
     * Constructor method for FileInfo
     * @uses FileInfo::setFile()
     * @param \Sabre\PassengerDetailsRQ\Structs\File[] $file
     */
    public function __construct(array $file = array())
    {
        $this
            ->setFile($file);
    }
    /**
     * Get File value
     * @return \Sabre\PassengerDetailsRQ\Structs\File[]|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\File[] $file
     * @return \Sabre\PassengerDetailsRQ\Structs\FileInfo
     */
    public function setFile(array $file = array())
    {
        $this->File = $file;
        return $this;
    }
    /**
     * Add item to File value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\File $item
     * @return \Sabre\PassengerDetailsRQ\Structs\FileInfo
     */
    public function addToFile(\Sabre\PassengerDetailsRQ\Structs\File $item)
    {
        $this->File[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\FileInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
