<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Endorsements Structs
 * @subpackage Structs
 */
class Endorsements extends AbstractStructBase
{
    /**
     * The Endorsement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Endorsement[]
     */
    public $Endorsement;
    /**
     * Constructor method for Endorsements
     * @uses Endorsements::setEndorsement()
     * @param \Sabre\PassengerDetailsRQ\Structs\Endorsement[] $endorsement
     */
    public function __construct(array $endorsement = array())
    {
        $this
            ->setEndorsement($endorsement);
    }
    /**
     * Get Endorsement value
     * @return \Sabre\PassengerDetailsRQ\Structs\Endorsement[]|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Endorsement[] $endorsement
     * @return \Sabre\PassengerDetailsRQ\Structs\Endorsements
     */
    public function setEndorsement(array $endorsement = array())
    {
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Add item to Endorsement value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Endorsement $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Endorsements
     */
    public function addToEndorsement(\Sabre\PassengerDetailsRQ\Structs\Endorsement $item)
    {
        $this->Endorsement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Endorsements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
