<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactNumber Structs
 * @subpackage Structs
 */
class ContactNumber extends AbstractStructBase
{
    /**
     * The PhoneUseType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PhoneUseType;
    /**
     * The InsertAfter
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $InsertAfter;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the city code associated to the phone number.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - documentation: "Phone" is used to return the telephone number. | "Phone" is used to return the telephone number associated with the particular credit card holder. | "Phone" is used to return the hotel's telephone number. | "Phone" is used to return
     * the phone number associated with the particular location. | "Phone" is used to return the collection site phone number associated with the vehicle reservation if applicable. | "Phone" is used to return the delivery site phone number associated with
     * the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $Phone;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - documentation: "Fax" is used to return the hotel's fax number. | "Fax" is used to return the fax number associated with the particular location.
     * - use: optional
     * @var string
     */
    public $Fax;
    /**
     * Constructor method for ContactNumber
     * @uses ContactNumber::setPhoneUseType()
     * @uses ContactNumber::setInsertAfter()
     * @uses ContactNumber::setLocationCode()
     * @uses ContactNumber::setNameNumber()
     * @uses ContactNumber::setPhone()
     * @uses ContactNumber::setPersonName()
     * @uses ContactNumber::setRPH()
     * @uses ContactNumber::setId()
     * @uses ContactNumber::setFax()
     * @param string $phoneUseType
     * @param int $insertAfter
     * @param string $locationCode
     * @param string $nameNumber
     * @param string $phone
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @param string $rPH
     * @param string $id
     * @param string $fax
     */
    public function __construct($phoneUseType = null, $insertAfter = null, $locationCode = null, $nameNumber = null, $phone = null, array $personName = array(), $rPH = null, $id = null, $fax = null)
    {
        $this
            ->setPhoneUseType($phoneUseType)
            ->setInsertAfter($insertAfter)
            ->setLocationCode($locationCode)
            ->setNameNumber($nameNumber)
            ->setPhone($phone)
            ->setPersonName($personName)
            ->setRPH($rPH)
            ->setId($id)
            ->setFax($fax);
    }
    /**
     * Get PhoneUseType value
     * @return string
     */
    public function getPhoneUseType()
    {
        return $this->PhoneUseType;
    }
    /**
     * Set PhoneUseType value
     * @param string $phoneUseType
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setPhoneUseType($phoneUseType = null)
    {
        $this->PhoneUseType = $phoneUseType;
        return $this;
    }
    /**
     * Get InsertAfter value
     * @return int|null
     */
    public function getInsertAfter()
    {
        return $this->InsertAfter;
    }
    /**
     * Set InsertAfter value
     * @param int $insertAfter
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setInsertAfter($insertAfter = null)
    {
        $this->InsertAfter = $insertAfter;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setPhone($phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function addToPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public function setFax($fax = null)
    {
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
