<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTaxi Structs
 * @subpackage Structs
 */
class AirTaxi extends AbstractStructBase
{
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous free text associated with the particular segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Vendor
     */
    public $Vendor;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator.
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "DepartureDateTime" is used to return the scheduled departure date/time associated with the particular segment. | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The LinkCode
     * Meta informations extracted from the WSDL
     * - documentation: "LinkCode" is used to return the link code
     * - use: optional
     * @var string
     */
    public $LinkCode;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular cruise segment.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Type" is used to return the segment type
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on AirTaxi - @DepartureDateTime, AirTaxi - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * Constructor method for AirTaxi
     * @uses AirTaxi::setDestinationLocation()
     * @uses AirTaxi::setOriginLocation()
     * @uses AirTaxi::setText()
     * @uses AirTaxi::setVendor()
     * @uses AirTaxi::setDayOfWeekInd()
     * @uses AirTaxi::setDepartureDateTime()
     * @uses AirTaxi::setLinkCode()
     * @uses AirTaxi::setNumberInParty()
     * @uses AirTaxi::setSegmentNumber()
     * @uses AirTaxi::setStatus()
     * @uses AirTaxi::setType()
     * @uses AirTaxi::setIsPast()
     * @param \Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation
     * @param string[] $text
     * @param \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor
     * @param string $dayOfWeekInd
     * @param string $departureDateTime
     * @param string $linkCode
     * @param string $numberInParty
     * @param string $segmentNumber
     * @param string $status
     * @param string $type
     * @param bool $isPast
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation = null, \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation = null, array $text = array(), \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor = null, $dayOfWeekInd = null, $departureDateTime = null, $linkCode = null, $numberInParty = null, $segmentNumber = null, $status = null, $type = null, $isPast = null)
    {
        $this
            ->setDestinationLocation($destinationLocation)
            ->setOriginLocation($originLocation)
            ->setText($text)
            ->setVendor($vendor)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setDepartureDateTime($departureDateTime)
            ->setLinkCode($linkCode)
            ->setNumberInParty($numberInParty)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setType($type)
            ->setIsPast($isPast);
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\PassengerDetailsRQ\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setDestinationLocation(\Sabre\PassengerDetailsRQ\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\PassengerDetailsRQ\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setOriginLocation(\Sabre\PassengerDetailsRQ\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\PassengerDetailsRQ\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\PassengerDetailsRQ\Structs\Vendor $vendor
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setVendor(\Sabre\PassengerDetailsRQ\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get LinkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->LinkCode;
    }
    /**
     * Set LinkCode value
     * @param string $linkCode
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setLinkCode($linkCode = null)
    {
        $this->LinkCode = $linkCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
