<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalSurcharge Structs
 * @subpackage Structs
 */
class TotalSurcharge extends AbstractStructBase
{
    /**
     * The Surcharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Surcharge[]
     */
    public $Surcharge;
    /**
     * The Amount
     * @var string
     */
    public $Amount;
    /**
     * Constructor method for TotalSurcharge
     * @uses TotalSurcharge::setSurcharge()
     * @uses TotalSurcharge::setAmount()
     * @param \Sabre\PassengerDetailsRQ\Structs\Surcharge[] $surcharge
     * @param string $amount
     */
    public function __construct(array $surcharge = array(), $amount = null)
    {
        $this
            ->setSurcharge($surcharge)
            ->setAmount($amount);
    }
    /**
     * Get Surcharge value
     * @return \Sabre\PassengerDetailsRQ\Structs\Surcharge[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Surcharge[] $surcharge
     * @return \Sabre\PassengerDetailsRQ\Structs\TotalSurcharge
     */
    public function setSurcharge(array $surcharge = array())
    {
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Surcharge $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TotalSurcharge
     */
    public function addToSurcharge(\Sabre\PassengerDetailsRQ\Structs\Surcharge $item)
    {
        $this->Surcharge[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\PassengerDetailsRQ\Structs\TotalSurcharge
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\TotalSurcharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
