<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: "TicketingInfo" is used as a container for Ticketing Information
 * @subpackage Structs
 */
class TicketingInfo extends AbstractStructBase
{
    /**
     * The eTicket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ETicket
     */
    public $eTicket;
    /**
     * The Exchange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Exchange
     */
    public $Exchange;
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - documentation: "IssueDate" is used to return the issue date associated with the particular accounting line if applicable. | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueLocation
     * Meta informations extracted from the WSDL
     * - documentation: "IssueLocation" is used to return the issue location associated with the particular accounting line if applicable
     * - minOccurs: 0
     * @var string
     */
    public $IssueLocation;
    /**
     * The OriginalInvoiceNumber
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return the original invoice number associated with the particular accounting line if applicable.
     * - minOccurs: 0
     * @var string
     */
    public $OriginalInvoiceNumber;
    /**
     * The OriginalTicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: "OriginalTicketNumber" is used to return the original ticket number associated with the particular accounting line if applicable.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var string[]
     */
    public $OriginalTicketNumber;
    /**
     * The TariffBasis
     * Meta informations extracted from the WSDL
     * - documentation: "TariffBasis" is used to return tarriff basis-related information associated with the particular accounting line if applicable.
     * - minOccurs: 0
     * @var string
     */
    public $TariffBasis;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Ticketing
     */
    public $Ticketing;
    /**
     * Constructor method for TicketingInfo
     * @uses TicketingInfo::setETicket()
     * @uses TicketingInfo::setExchange()
     * @uses TicketingInfo::setIssueDate()
     * @uses TicketingInfo::setIssueLocation()
     * @uses TicketingInfo::setOriginalInvoiceNumber()
     * @uses TicketingInfo::setOriginalTicketNumber()
     * @uses TicketingInfo::setTariffBasis()
     * @uses TicketingInfo::setTicketing()
     * @param \Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket
     * @param \Sabre\PassengerDetailsRQ\Structs\Exchange $exchange
     * @param string $issueDate
     * @param string $issueLocation
     * @param string $originalInvoiceNumber
     * @param string[] $originalTicketNumber
     * @param string $tariffBasis
     * @param \Sabre\PassengerDetailsRQ\Structs\Ticketing $ticketing
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket = null, \Sabre\PassengerDetailsRQ\Structs\Exchange $exchange = null, $issueDate = null, $issueLocation = null, $originalInvoiceNumber = null, array $originalTicketNumber = array(), $tariffBasis = null, \Sabre\PassengerDetailsRQ\Structs\Ticketing $ticketing = null)
    {
        $this
            ->setETicket($eTicket)
            ->setExchange($exchange)
            ->setIssueDate($issueDate)
            ->setIssueLocation($issueLocation)
            ->setOriginalInvoiceNumber($originalInvoiceNumber)
            ->setOriginalTicketNumber($originalTicketNumber)
            ->setTariffBasis($tariffBasis)
            ->setTicketing($ticketing);
    }
    /**
     * Get eTicket value
     * @return \Sabre\PassengerDetailsRQ\Structs\ETicket|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param \Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setETicket(\Sabre\PassengerDetailsRQ\Structs\ETicket $eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get Exchange value
     * @return \Sabre\PassengerDetailsRQ\Structs\Exchange|null
     */
    public function getExchange()
    {
        return $this->Exchange;
    }
    /**
     * Set Exchange value
     * @param \Sabre\PassengerDetailsRQ\Structs\Exchange $exchange
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setExchange(\Sabre\PassengerDetailsRQ\Structs\Exchange $exchange = null)
    {
        $this->Exchange = $exchange;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setIssueDate($issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueLocation value
     * @return string|null
     */
    public function getIssueLocation()
    {
        return $this->IssueLocation;
    }
    /**
     * Set IssueLocation value
     * @param string $issueLocation
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setIssueLocation($issueLocation = null)
    {
        $this->IssueLocation = $issueLocation;
        return $this;
    }
    /**
     * Get OriginalInvoiceNumber value
     * @return string|null
     */
    public function getOriginalInvoiceNumber()
    {
        return $this->OriginalInvoiceNumber;
    }
    /**
     * Set OriginalInvoiceNumber value
     * @param string $originalInvoiceNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setOriginalInvoiceNumber($originalInvoiceNumber = null)
    {
        $this->OriginalInvoiceNumber = $originalInvoiceNumber;
        return $this;
    }
    /**
     * Get OriginalTicketNumber value
     * @return string[]|null
     */
    public function getOriginalTicketNumber()
    {
        return $this->OriginalTicketNumber;
    }
    /**
     * Set OriginalTicketNumber value
     * @throws \InvalidArgumentException
     * @param string[] $originalTicketNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setOriginalTicketNumber(array $originalTicketNumber = array())
    {
        $this->OriginalTicketNumber = $originalTicketNumber;
        return $this;
    }
    /**
     * Add item to OriginalTicketNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function addToOriginalTicketNumber($item)
    {
        $this->OriginalTicketNumber[] = $item;
        return $this;
    }
    /**
     * Get TariffBasis value
     * @return string|null
     */
    public function getTariffBasis()
    {
        return $this->TariffBasis;
    }
    /**
     * Set TariffBasis value
     * @param string $tariffBasis
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setTariffBasis($tariffBasis = null)
    {
        $this->TariffBasis = $tariffBasis;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \Sabre\PassengerDetailsRQ\Structs\Ticketing|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @param \Sabre\PassengerDetailsRQ\Structs\Ticketing $ticketing
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public function setTicketing(\Sabre\PassengerDetailsRQ\Structs\Ticketing $ticketing = null)
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\TicketingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
