<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes Structs
 * Meta informations extracted from the WSDL
 * - documentation: Taxes is used as a container for Tax details. It holds the details for GST, QST and Tax. For GST information about amount, Currency code and Percentage is present for QST and Tax along with information about amount, Currency code,
 * Percentage Tax code details is also included. | "Taxes" is used to reflect the total tax details | "Taxes" is used to reflect the total tax details | Taxes is used to reflect the total tax details | "Taxes" element is used as container for taxes
 * associated with particular ancillary.
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The GST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\GST
     */
    public $GST;
    /**
     * The QST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\QST
     */
    public $QST;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Tax[]
     */
    public $Tax;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - documentation: "TotalAmount" is used to return the applicable amount. | "TotalAmount" is used to return the applicable amount.
     * - use: optional
     * @var string
     */
    public $TotalAmount;
    /**
     * The TaxBreakdownCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\TaxBreakdownCode[]
     */
    public $TaxBreakdownCode;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setGST()
     * @uses Taxes::setQST()
     * @uses Taxes::setTax()
     * @uses Taxes::setTotalAmount()
     * @uses Taxes::setTaxBreakdownCode()
     * @param \Sabre\PassengerDetailsRQ\Structs\GST $gST
     * @param \Sabre\PassengerDetailsRQ\Structs\QST $qST
     * @param \Sabre\PassengerDetailsRQ\Structs\Tax[] $tax
     * @param string $totalAmount
     * @param \Sabre\PassengerDetailsRQ\Structs\TaxBreakdownCode[] $taxBreakdownCode
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\GST $gST = null, \Sabre\PassengerDetailsRQ\Structs\QST $qST = null, array $tax = array(), $totalAmount = null, array $taxBreakdownCode = array())
    {
        $this
            ->setGST($gST)
            ->setQST($qST)
            ->setTax($tax)
            ->setTotalAmount($totalAmount)
            ->setTaxBreakdownCode($taxBreakdownCode);
    }
    /**
     * Get GST value
     * @return \Sabre\PassengerDetailsRQ\Structs\GST|null
     */
    public function getGST()
    {
        return $this->GST;
    }
    /**
     * Set GST value
     * @param \Sabre\PassengerDetailsRQ\Structs\GST $gST
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public function setGST(\Sabre\PassengerDetailsRQ\Structs\GST $gST = null)
    {
        $this->GST = $gST;
        return $this;
    }
    /**
     * Get QST value
     * @return \Sabre\PassengerDetailsRQ\Structs\QST|null
     */
    public function getQST()
    {
        return $this->QST;
    }
    /**
     * Set QST value
     * @param \Sabre\PassengerDetailsRQ\Structs\QST $qST
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public function setQST(\Sabre\PassengerDetailsRQ\Structs\QST $qST = null)
    {
        $this->QST = $qST;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\PassengerDetailsRQ\Structs\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Tax[] $tax
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\Tax $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public function addToTax(\Sabre\PassengerDetailsRQ\Structs\Tax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get TaxBreakdownCode value
     * @return \Sabre\PassengerDetailsRQ\Structs\TaxBreakdownCode[]|null
     */
    public function getTaxBreakdownCode()
    {
        return $this->TaxBreakdownCode;
    }
    /**
     * Set TaxBreakdownCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\TaxBreakdownCode[] $taxBreakdownCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public function setTaxBreakdownCode(array $taxBreakdownCode = array())
    {
        $this->TaxBreakdownCode = $taxBreakdownCode;
        return $this;
    }
    /**
     * Add item to TaxBreakdownCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\TaxBreakdownCode $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public function addToTaxBreakdownCode(\Sabre\PassengerDetailsRQ\Structs\TaxBreakdownCode $item)
    {
        $this->TaxBreakdownCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Taxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
