<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StateCountyProv Structs
 * @subpackage Structs
 */
class StateCountyProv extends AbstractStructBase
{
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - documentation: "StateCode" is used to return the collection site state code associated with the vehicle reservation if applicable. | "StateCode" is used to return the delivery site state code associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $StateCode;
    /**
     * Constructor method for StateCountyProv
     * @uses StateCountyProv::setStateCode()
     * @param string $stateCode
     */
    public function __construct($stateCode = null)
    {
        $this
            ->setStateCode($stateCode);
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \Sabre\PassengerDetailsRQ\Structs\StateCountyProv
     */
    public function setStateCode($stateCode = null)
    {
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\StateCountyProv
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
