<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reservation Structs
 * Meta informations extracted from the WSDL
 * - documentation: Hotel reservation information.
 * @subpackage Structs
 */
class Reservation extends AbstractStructBase
{
    /**
     * The LineNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LineNumber;
    /**
     * The LineType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LineType;
    /**
     * The LineStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LineStatus;
    /**
     * The POSRequestorID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $POSRequestorID;
    /**
     * The SpecialPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SpecialPrefs
     */
    public $SpecialPrefs;
    /**
     * The RoomType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RoomType
     */
    public $RoomType;
    /**
     * The RoomRates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RoomRates
     */
    public $RoomRates;
    /**
     * The RateAccessCodeBooked
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked
     */
    public $RateAccessCodeBooked;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\GuestCounts
     */
    public $GuestCounts;
    /**
     * The TimeSpanStart
     * Meta informations extracted from the WSDL
     * - documentation: The starting value of the time span. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm",
     * "yyyy-mm-ddThh:mm"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeSpanStart;
    /**
     * The TimeSpanDuration
     * Meta informations extracted from the WSDL
     * - documentation: The lexical representation for timeDuration is the [ISO 8601] extended format PnYn MnDTnH nMnS, where nY represents the number of years, nM the number of months, nD the number of days, 'T' is the date/time separator, nH the number of
     * hours, nM the number of minutes and nS the number of seconds. The number of seconds can include decimal digits to arbitrary precision. As an example, 7 months, 2 days, 2hours and 30 minutes would be expressed as P0Y7M2DT2H30M0S. Truncated
     * representations are allowed provided they conform to ISO 8601 format.
     * - minOccurs: 0
     * @var string
     */
    public $TimeSpanDuration;
    /**
     * The TimeSpanEnd
     * Meta informations extracted from the WSDL
     * - documentation: The ending value of the time span. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm",
     * "yyyy-mm-ddThh:mm"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeSpanEnd;
    /**
     * The Guarantee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Guarantee
     */
    public $Guarantee;
    /**
     * The ChainCode
     * Meta informations extracted from the WSDL
     * - documentation: The code that identifies a hotel chain or management group. The hotel chain code is decided between vendors. This attribute is optional if the hotel is an independent property that can be identified by the HotelCode attribute.
     * - minOccurs: 0
     * @var string
     */
    public $ChainCode;
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\HotelCode[]
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * Meta informations extracted from the WSDL
     * - documentation: The IATA city code; for example DCA, ORD.
     * - minOccurs: 0
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - documentation: A text field used to communicate the proper name of the hotel.
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The HotelTotalPricing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\HotelTotalPricing
     */
    public $HotelTotalPricing;
    /**
     * The HotelUniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\HotelUniqueIDType[]
     */
    public $HotelUniqueID;
    /**
     * Constructor method for Reservation
     * @uses Reservation::setLineNumber()
     * @uses Reservation::setLineType()
     * @uses Reservation::setLineStatus()
     * @uses Reservation::setPOSRequestorID()
     * @uses Reservation::setSpecialPrefs()
     * @uses Reservation::setRoomType()
     * @uses Reservation::setRoomRates()
     * @uses Reservation::setRateAccessCodeBooked()
     * @uses Reservation::setGuestCounts()
     * @uses Reservation::setTimeSpanStart()
     * @uses Reservation::setTimeSpanDuration()
     * @uses Reservation::setTimeSpanEnd()
     * @uses Reservation::setGuarantee()
     * @uses Reservation::setChainCode()
     * @uses Reservation::setHotelCode()
     * @uses Reservation::setHotelCityCode()
     * @uses Reservation::setHotelName()
     * @uses Reservation::setHotelTotalPricing()
     * @uses Reservation::setHotelUniqueID()
     * @param int $lineNumber
     * @param string $lineType
     * @param string $lineStatus
     * @param string $pOSRequestorID
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialPrefs $specialPrefs
     * @param \Sabre\PassengerDetailsRQ\Structs\RoomType $roomType
     * @param \Sabre\PassengerDetailsRQ\Structs\RoomRates $roomRates
     * @param \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked $rateAccessCodeBooked
     * @param \Sabre\PassengerDetailsRQ\Structs\GuestCounts $guestCounts
     * @param string $timeSpanStart
     * @param string $timeSpanDuration
     * @param string $timeSpanEnd
     * @param \Sabre\PassengerDetailsRQ\Structs\Guarantee $guarantee
     * @param string $chainCode
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelCode[] $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelTotalPricing $hotelTotalPricing
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelUniqueIDType[] $hotelUniqueID
     */
    public function __construct($lineNumber = null, $lineType = null, $lineStatus = null, $pOSRequestorID = null, \Sabre\PassengerDetailsRQ\Structs\SpecialPrefs $specialPrefs = null, \Sabre\PassengerDetailsRQ\Structs\RoomType $roomType = null, \Sabre\PassengerDetailsRQ\Structs\RoomRates $roomRates = null, \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked $rateAccessCodeBooked = null, \Sabre\PassengerDetailsRQ\Structs\GuestCounts $guestCounts = null, $timeSpanStart = null, $timeSpanDuration = null, $timeSpanEnd = null, \Sabre\PassengerDetailsRQ\Structs\Guarantee $guarantee = null, $chainCode = null, array $hotelCode = array(), $hotelCityCode = null, $hotelName = null, \Sabre\PassengerDetailsRQ\Structs\HotelTotalPricing $hotelTotalPricing = null, array $hotelUniqueID = array())
    {
        $this
            ->setLineNumber($lineNumber)
            ->setLineType($lineType)
            ->setLineStatus($lineStatus)
            ->setPOSRequestorID($pOSRequestorID)
            ->setSpecialPrefs($specialPrefs)
            ->setRoomType($roomType)
            ->setRoomRates($roomRates)
            ->setRateAccessCodeBooked($rateAccessCodeBooked)
            ->setGuestCounts($guestCounts)
            ->setTimeSpanStart($timeSpanStart)
            ->setTimeSpanDuration($timeSpanDuration)
            ->setTimeSpanEnd($timeSpanEnd)
            ->setGuarantee($guarantee)
            ->setChainCode($chainCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelTotalPricing($hotelTotalPricing)
            ->setHotelUniqueID($hotelUniqueID);
    }
    /**
     * Get LineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setLineNumber($lineNumber = null)
    {
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get LineType value
     * @return string|null
     */
    public function getLineType()
    {
        return $this->LineType;
    }
    /**
     * Set LineType value
     * @param string $lineType
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setLineType($lineType = null)
    {
        $this->LineType = $lineType;
        return $this;
    }
    /**
     * Get LineStatus value
     * @return string|null
     */
    public function getLineStatus()
    {
        return $this->LineStatus;
    }
    /**
     * Set LineStatus value
     * @param string $lineStatus
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setLineStatus($lineStatus = null)
    {
        $this->LineStatus = $lineStatus;
        return $this;
    }
    /**
     * Get POSRequestorID value
     * @return string|null
     */
    public function getPOSRequestorID()
    {
        return $this->POSRequestorID;
    }
    /**
     * Set POSRequestorID value
     * @param string $pOSRequestorID
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setPOSRequestorID($pOSRequestorID = null)
    {
        $this->POSRequestorID = $pOSRequestorID;
        return $this;
    }
    /**
     * Get SpecialPrefs value
     * @return \Sabre\PassengerDetailsRQ\Structs\SpecialPrefs|null
     */
    public function getSpecialPrefs()
    {
        return $this->SpecialPrefs;
    }
    /**
     * Set SpecialPrefs value
     * @param \Sabre\PassengerDetailsRQ\Structs\SpecialPrefs $specialPrefs
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setSpecialPrefs(\Sabre\PassengerDetailsRQ\Structs\SpecialPrefs $specialPrefs = null)
    {
        $this->SpecialPrefs = $specialPrefs;
        return $this;
    }
    /**
     * Get RoomType value
     * @return \Sabre\PassengerDetailsRQ\Structs\RoomType|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param \Sabre\PassengerDetailsRQ\Structs\RoomType $roomType
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setRoomType(\Sabre\PassengerDetailsRQ\Structs\RoomType $roomType = null)
    {
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \Sabre\PassengerDetailsRQ\Structs\RoomRates|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \Sabre\PassengerDetailsRQ\Structs\RoomRates $roomRates
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setRoomRates(\Sabre\PassengerDetailsRQ\Structs\RoomRates $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get RateAccessCodeBooked value
     * @return \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked|null
     */
    public function getRateAccessCodeBooked()
    {
        return $this->RateAccessCodeBooked;
    }
    /**
     * Set RateAccessCodeBooked value
     * @param \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked $rateAccessCodeBooked
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setRateAccessCodeBooked(\Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked $rateAccessCodeBooked = null)
    {
        $this->RateAccessCodeBooked = $rateAccessCodeBooked;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \Sabre\PassengerDetailsRQ\Structs\GuestCounts|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \Sabre\PassengerDetailsRQ\Structs\GuestCounts $guestCounts
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setGuestCounts(\Sabre\PassengerDetailsRQ\Structs\GuestCounts $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpanStart value
     * @return string|null
     */
    public function getTimeSpanStart()
    {
        return $this->TimeSpanStart;
    }
    /**
     * Set TimeSpanStart value
     * @param string $timeSpanStart
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setTimeSpanStart($timeSpanStart = null)
    {
        $this->TimeSpanStart = $timeSpanStart;
        return $this;
    }
    /**
     * Get TimeSpanDuration value
     * @return string|null
     */
    public function getTimeSpanDuration()
    {
        return $this->TimeSpanDuration;
    }
    /**
     * Set TimeSpanDuration value
     * @param string $timeSpanDuration
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setTimeSpanDuration($timeSpanDuration = null)
    {
        $this->TimeSpanDuration = $timeSpanDuration;
        return $this;
    }
    /**
     * Get TimeSpanEnd value
     * @return string|null
     */
    public function getTimeSpanEnd()
    {
        return $this->TimeSpanEnd;
    }
    /**
     * Set TimeSpanEnd value
     * @param string $timeSpanEnd
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setTimeSpanEnd($timeSpanEnd = null)
    {
        $this->TimeSpanEnd = $timeSpanEnd;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return \Sabre\PassengerDetailsRQ\Structs\Guarantee|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @param \Sabre\PassengerDetailsRQ\Structs\Guarantee $guarantee
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setGuarantee(\Sabre\PassengerDetailsRQ\Structs\Guarantee $guarantee = null)
    {
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setChainCode($chainCode = null)
    {
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return \Sabre\PassengerDetailsRQ\Structs\HotelCode[]|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelCode[] $hotelCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setHotelCode(array $hotelCode = array())
    {
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Add item to HotelCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelCode $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function addToHotelCode(\Sabre\PassengerDetailsRQ\Structs\HotelCode $item)
    {
        $this->HotelCode[] = $item;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setHotelName($hotelName = null)
    {
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelTotalPricing value
     * @return \Sabre\PassengerDetailsRQ\Structs\HotelTotalPricing|null
     */
    public function getHotelTotalPricing()
    {
        return $this->HotelTotalPricing;
    }
    /**
     * Set HotelTotalPricing value
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelTotalPricing $hotelTotalPricing
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setHotelTotalPricing(\Sabre\PassengerDetailsRQ\Structs\HotelTotalPricing $hotelTotalPricing = null)
    {
        $this->HotelTotalPricing = $hotelTotalPricing;
        return $this;
    }
    /**
     * Get HotelUniqueID value
     * @return \Sabre\PassengerDetailsRQ\Structs\HotelUniqueIDType[]|null
     */
    public function getHotelUniqueID()
    {
        return $this->HotelUniqueID;
    }
    /**
     * Set HotelUniqueID value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelUniqueIDType[] $hotelUniqueID
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function setHotelUniqueID(array $hotelUniqueID = array())
    {
        $this->HotelUniqueID = $hotelUniqueID;
        return $this;
    }
    /**
     * Add item to HotelUniqueID value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\HotelUniqueIDType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public function addToHotelUniqueID(\Sabre\PassengerDetailsRQ\Structs\HotelUniqueIDType $item)
    {
        $this->HotelUniqueID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Reservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
