<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateAccessCodeBooked Structs
 * Meta informations extracted from the WSDL
 * - documentation: "RateAccessCodeBooked" is used to return the number of Rate access code booked associated with the particular hotel reservation if applicable.
 * @subpackage Structs
 */
class RateAccessCodeBooked extends AbstractStructBase
{
    /**
     * The ClientIdentificationCode
     * Meta informations extracted from the WSDL
     * - documentation: "ClientIdentificationCode" is used to return the identification code for the vendor associated with the particular hotel reservation.
     * - minOccurs: 0
     * @var string
     */
    public $ClientIdentificationCode;
    /**
     * The RateAccessCode
     * Meta informations extracted from the WSDL
     * - documentation: "RateAccessCode" is used to return the rate access code of the agency.
     * - minOccurs: 0
     * @var string
     */
    public $RateAccessCode;
    /**
     * The CategoryTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: "CategoryTypeCode" is used to return the category type code associated with the particular hotel when applicable.
     * - minOccurs: 0
     * @var string
     */
    public $CategoryTypeCode;
    /**
     * Constructor method for RateAccessCodeBooked
     * @uses RateAccessCodeBooked::setClientIdentificationCode()
     * @uses RateAccessCodeBooked::setRateAccessCode()
     * @uses RateAccessCodeBooked::setCategoryTypeCode()
     * @param string $clientIdentificationCode
     * @param string $rateAccessCode
     * @param string $categoryTypeCode
     */
    public function __construct($clientIdentificationCode = null, $rateAccessCode = null, $categoryTypeCode = null)
    {
        $this
            ->setClientIdentificationCode($clientIdentificationCode)
            ->setRateAccessCode($rateAccessCode)
            ->setCategoryTypeCode($categoryTypeCode);
    }
    /**
     * Get ClientIdentificationCode value
     * @return string|null
     */
    public function getClientIdentificationCode()
    {
        return $this->ClientIdentificationCode;
    }
    /**
     * Set ClientIdentificationCode value
     * @param string $clientIdentificationCode
     * @return \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked
     */
    public function setClientIdentificationCode($clientIdentificationCode = null)
    {
        $this->ClientIdentificationCode = $clientIdentificationCode;
        return $this;
    }
    /**
     * Get RateAccessCode value
     * @return string|null
     */
    public function getRateAccessCode()
    {
        return $this->RateAccessCode;
    }
    /**
     * Set RateAccessCode value
     * @param string $rateAccessCode
     * @return \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked
     */
    public function setRateAccessCode($rateAccessCode = null)
    {
        $this->RateAccessCode = $rateAccessCode;
        return $this;
    }
    /**
     * Get CategoryTypeCode value
     * @return string|null
     */
    public function getCategoryTypeCode()
    {
        return $this->CategoryTypeCode;
    }
    /**
     * Set CategoryTypeCode value
     * @param string $categoryTypeCode
     * @return \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked
     */
    public function setCategoryTypeCode($categoryTypeCode = null)
    {
        $this->CategoryTypeCode = $categoryTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\RateAccessCodeBooked
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
