<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProblemInformation Structs
 * Meta informations extracted from the WSDL
 * - type: ProblemInformation
 * @subpackage Structs
 */
class ProblemInformation extends AbstractStructBase
{
    /**
     * The SystemSpecificResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\SystemSpecificResults[]
     */
    public $SystemSpecificResults;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: An indication of the source of error when processing the request.
     * @var string
     */
    public $type;
    /**
     * The timeStamp
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for ProblemInformation
     * @uses ProblemInformation::setSystemSpecificResults()
     * @uses ProblemInformation::setType()
     * @uses ProblemInformation::setTimeStamp()
     * @param \Sabre\PassengerDetailsRQ\Structs\SystemSpecificResults[] $systemSpecificResults
     * @param string $type
     * @param string $timeStamp
     */
    public function __construct(array $systemSpecificResults = array(), $type = null, $timeStamp = null)
    {
        $this
            ->setSystemSpecificResults($systemSpecificResults)
            ->setType($type)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get SystemSpecificResults value
     * @return \Sabre\PassengerDetailsRQ\Structs\SystemSpecificResults[]|null
     */
    public function getSystemSpecificResults()
    {
        return $this->SystemSpecificResults;
    }
    /**
     * Set SystemSpecificResults value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SystemSpecificResults[] $systemSpecificResults
     * @return \Sabre\PassengerDetailsRQ\Structs\ProblemInformation
     */
    public function setSystemSpecificResults(array $systemSpecificResults = array())
    {
        $this->SystemSpecificResults = $systemSpecificResults;
        return $this;
    }
    /**
     * Add item to SystemSpecificResults value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\SystemSpecificResults $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ProblemInformation
     */
    public function addToSystemSpecificResults(\Sabre\PassengerDetailsRQ\Structs\SystemSpecificResults $item)
    {
        $this->SystemSpecificResults[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \Sabre\PassengerDetailsRQ\Enums\ErrorType::valueIsValid()
     * @uses \Sabre\PassengerDetailsRQ\Enums\ErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\ProblemInformation
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \Sabre\PassengerDetailsRQ\Structs\ProblemInformation
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ProblemInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
