<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: PayInfo contains data in the PAY field in the PNR
 * @subpackage Structs
 */
class PayInfo extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Credit card number
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The FieldTagID
     * Meta informations extracted from the WSDL
     * - documentation: Optional field Example: CC_Code
     * - use: optional
     * @var string
     */
    public $FieldTagID;
    /**
     * The LinkSubkey
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LinkSubkey;
    /**
     * The SectionID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SectionID;
    /**
     * The SecurityIndicator
     * Meta informations extracted from the WSDL
     * - documentation: Holds Security indicator details Example: E for Encryption , M for Masking, B for Both, X for Inhibit Display
     * - use: optional
     * @var string
     */
    public $SecurityIndicator;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for PayInfo
     * @uses PayInfo::setPersonName()
     * @uses PayInfo::setText()
     * @uses PayInfo::setFieldTagID()
     * @uses PayInfo::setLinkSubkey()
     * @uses PayInfo::setSectionID()
     * @uses PayInfo::setSecurityIndicator()
     * @uses PayInfo::setId()
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @param string $text
     * @param string $fieldTagID
     * @param string $linkSubkey
     * @param string $sectionID
     * @param string $securityIndicator
     * @param string $id
     */
    public function __construct(array $personName = array(), $text = null, $fieldTagID = null, $linkSubkey = null, $sectionID = null, $securityIndicator = null, $id = null)
    {
        $this
            ->setPersonName($personName)
            ->setText($text)
            ->setFieldTagID($fieldTagID)
            ->setLinkSubkey($linkSubkey)
            ->setSectionID($sectionID)
            ->setSecurityIndicator($securityIndicator)
            ->setId($id);
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName[] $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonName $item
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function addToPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get FieldTagID value
     * @return string|null
     */
    public function getFieldTagID()
    {
        return $this->FieldTagID;
    }
    /**
     * Set FieldTagID value
     * @param string $fieldTagID
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function setFieldTagID($fieldTagID = null)
    {
        $this->FieldTagID = $fieldTagID;
        return $this;
    }
    /**
     * Get LinkSubkey value
     * @return string|null
     */
    public function getLinkSubkey()
    {
        return $this->LinkSubkey;
    }
    /**
     * Set LinkSubkey value
     * @param string $linkSubkey
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function setLinkSubkey($linkSubkey = null)
    {
        $this->LinkSubkey = $linkSubkey;
        return $this;
    }
    /**
     * Get SectionID value
     * @return string|null
     */
    public function getSectionID()
    {
        return $this->SectionID;
    }
    /**
     * Set SectionID value
     * @param string $sectionID
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function setSectionID($sectionID = null)
    {
        $this->SectionID = $sectionID;
        return $this;
    }
    /**
     * Get SecurityIndicator value
     * @return string|null
     */
    public function getSecurityIndicator()
    {
        return $this->SecurityIndicator;
    }
    /**
     * Set SecurityIndicator value
     * @param string $securityIndicator
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function setSecurityIndicator($securityIndicator = null)
    {
        $this->SecurityIndicator = $securityIndicator;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\PayInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
