<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerType Structs
 * @subpackage Structs
 */
class PassengerType extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $Email;
    /**
     * The passengerID
     * @var string
     */
    public $passengerID;
    /**
     * The primary
     * @var bool
     */
    public $primary;
    /**
     * Constructor method for PassengerType
     * @uses PassengerType::setType()
     * @uses PassengerType::setPersonName()
     * @uses PassengerType::setTelephone()
     * @uses PassengerType::setEmail()
     * @uses PassengerType::setPassengerID()
     * @uses PassengerType::setPrimary()
     * @param string $type
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonNameType $personName
     * @param \Sabre\PassengerDetailsRQ\Structs\PhoneType[] $telephone
     * @param string[] $email
     * @param string $passengerID
     * @param bool $primary
     */
    public function __construct($type = null, \Sabre\PassengerDetailsRQ\Structs\PersonNameType $personName = null, array $telephone = array(), array $email = array(), $passengerID = null, $primary = null)
    {
        $this
            ->setType($type)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setPassengerID($passengerID)
            ->setPrimary($primary);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Sabre\PassengerDetailsRQ\Enums\Type::valueIsValid()
     * @uses \Sabre\PassengerDetailsRQ\Enums\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\PassengerDetailsRQ\Structs\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\PassengerDetailsRQ\Structs\PersonNameType $personName
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function setPersonName(\Sabre\PassengerDetailsRQ\Structs\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\PassengerDetailsRQ\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PhoneType[] $telephone
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PhoneType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function addToTelephone(\Sabre\PassengerDetailsRQ\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return string[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function addToEmail($item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get passengerID value
     * @return string|null
     */
    public function getPassengerID()
    {
        return $this->passengerID;
    }
    /**
     * Set passengerID value
     * @param string $passengerID
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function setPassengerID($passengerID = null)
    {
        $this->passengerID = $passengerID;
        return $this;
    }
    /**
     * Get primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param bool $primary
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public function setPrimary($primary = null)
    {
        $this->primary = $primary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
