<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item Structs
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The AirTaxi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\AirTaxi
     */
    public $AirTaxi;
    /**
     * The Arunk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Arunk
     */
    public $Arunk;
    /**
     * The Cruise
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Cruise
     */
    public $Cruise;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Hotel
     */
    public $Hotel;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Insurance
     */
    public $Insurance;
    /**
     * The MiscSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\MiscSegment
     */
    public $MiscSegment;
    /**
     * The Rail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Rail
     */
    public $Rail;
    /**
     * The Seats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Seats
     */
    public $Seats;
    /**
     * The Surface
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Surface
     */
    public $Surface;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Tour
     */
    public $Tour;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Vehicle
     */
    public $Vehicle;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ProductType
     */
    public $Product;
    /**
     * The Ancillaries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Ancillaries
     */
    public $Ancillaries;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Item
     * @uses Item::setAirTaxi()
     * @uses Item::setArunk()
     * @uses Item::setCruise()
     * @uses Item::setFlightSegment()
     * @uses Item::setHotel()
     * @uses Item::setInsurance()
     * @uses Item::setMiscSegment()
     * @uses Item::setRail()
     * @uses Item::setSeats()
     * @uses Item::setSurface()
     * @uses Item::setTour()
     * @uses Item::setVehicle()
     * @uses Item::setProduct()
     * @uses Item::setAncillaries()
     * @uses Item::setRPH()
     * @uses Item::setId()
     * @param \Sabre\PassengerDetailsRQ\Structs\AirTaxi $airTaxi
     * @param \Sabre\PassengerDetailsRQ\Structs\Arunk $arunk
     * @param \Sabre\PassengerDetailsRQ\Structs\Cruise $cruise
     * @param \Sabre\PassengerDetailsRQ\Structs\FlightSegment[] $flightSegment
     * @param \Sabre\PassengerDetailsRQ\Structs\Hotel $hotel
     * @param \Sabre\PassengerDetailsRQ\Structs\Insurance $insurance
     * @param \Sabre\PassengerDetailsRQ\Structs\MiscSegment $miscSegment
     * @param \Sabre\PassengerDetailsRQ\Structs\Rail $rail
     * @param \Sabre\PassengerDetailsRQ\Structs\Seats $seats
     * @param \Sabre\PassengerDetailsRQ\Structs\Surface $surface
     * @param \Sabre\PassengerDetailsRQ\Structs\Tour $tour
     * @param \Sabre\PassengerDetailsRQ\Structs\Vehicle $vehicle
     * @param \Sabre\PassengerDetailsRQ\Structs\ProductType $product
     * @param \Sabre\PassengerDetailsRQ\Structs\Ancillaries $ancillaries
     * @param string $rPH
     * @param string $id
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\AirTaxi $airTaxi = null, \Sabre\PassengerDetailsRQ\Structs\Arunk $arunk = null, \Sabre\PassengerDetailsRQ\Structs\Cruise $cruise = null, array $flightSegment = array(), \Sabre\PassengerDetailsRQ\Structs\Hotel $hotel = null, \Sabre\PassengerDetailsRQ\Structs\Insurance $insurance = null, \Sabre\PassengerDetailsRQ\Structs\MiscSegment $miscSegment = null, \Sabre\PassengerDetailsRQ\Structs\Rail $rail = null, \Sabre\PassengerDetailsRQ\Structs\Seats $seats = null, \Sabre\PassengerDetailsRQ\Structs\Surface $surface = null, \Sabre\PassengerDetailsRQ\Structs\Tour $tour = null, \Sabre\PassengerDetailsRQ\Structs\Vehicle $vehicle = null, \Sabre\PassengerDetailsRQ\Structs\ProductType $product = null, \Sabre\PassengerDetailsRQ\Structs\Ancillaries $ancillaries = null, $rPH = null, $id = null)
    {
        $this
            ->setAirTaxi($airTaxi)
            ->setArunk($arunk)
            ->setCruise($cruise)
            ->setFlightSegment($flightSegment)
            ->setHotel($hotel)
            ->setInsurance($insurance)
            ->setMiscSegment($miscSegment)
            ->setRail($rail)
            ->setSeats($seats)
            ->setSurface($surface)
            ->setTour($tour)
            ->setVehicle($vehicle)
            ->setProduct($product)
            ->setAncillaries($ancillaries)
            ->setRPH($rPH)
            ->setId($id);
    }
    /**
     * Get AirTaxi value
     * @return \Sabre\PassengerDetailsRQ\Structs\AirTaxi|null
     */
    public function getAirTaxi()
    {
        return $this->AirTaxi;
    }
    /**
     * Set AirTaxi value
     * @param \Sabre\PassengerDetailsRQ\Structs\AirTaxi $airTaxi
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setAirTaxi(\Sabre\PassengerDetailsRQ\Structs\AirTaxi $airTaxi = null)
    {
        $this->AirTaxi = $airTaxi;
        return $this;
    }
    /**
     * Get Arunk value
     * @return \Sabre\PassengerDetailsRQ\Structs\Arunk|null
     */
    public function getArunk()
    {
        return $this->Arunk;
    }
    /**
     * Set Arunk value
     * @param \Sabre\PassengerDetailsRQ\Structs\Arunk $arunk
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setArunk(\Sabre\PassengerDetailsRQ\Structs\Arunk $arunk = null)
    {
        $this->Arunk = $arunk;
        return $this;
    }
    /**
     * Get Cruise value
     * @return \Sabre\PassengerDetailsRQ\Structs\Cruise|null
     */
    public function getCruise()
    {
        return $this->Cruise;
    }
    /**
     * Set Cruise value
     * @param \Sabre\PassengerDetailsRQ\Structs\Cruise $cruise
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setCruise(\Sabre\PassengerDetailsRQ\Structs\Cruise $cruise = null)
    {
        $this->Cruise = $cruise;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\PassengerDetailsRQ\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\FlightSegment $item
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function addToFlightSegment(\Sabre\PassengerDetailsRQ\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \Sabre\PassengerDetailsRQ\Structs\Hotel|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @param \Sabre\PassengerDetailsRQ\Structs\Hotel $hotel
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setHotel(\Sabre\PassengerDetailsRQ\Structs\Hotel $hotel = null)
    {
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \Sabre\PassengerDetailsRQ\Structs\Insurance|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \Sabre\PassengerDetailsRQ\Structs\Insurance $insurance
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setInsurance(\Sabre\PassengerDetailsRQ\Structs\Insurance $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get MiscSegment value
     * @return \Sabre\PassengerDetailsRQ\Structs\MiscSegment|null
     */
    public function getMiscSegment()
    {
        return $this->MiscSegment;
    }
    /**
     * Set MiscSegment value
     * @param \Sabre\PassengerDetailsRQ\Structs\MiscSegment $miscSegment
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setMiscSegment(\Sabre\PassengerDetailsRQ\Structs\MiscSegment $miscSegment = null)
    {
        $this->MiscSegment = $miscSegment;
        return $this;
    }
    /**
     * Get Rail value
     * @return \Sabre\PassengerDetailsRQ\Structs\Rail|null
     */
    public function getRail()
    {
        return $this->Rail;
    }
    /**
     * Set Rail value
     * @param \Sabre\PassengerDetailsRQ\Structs\Rail $rail
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setRail(\Sabre\PassengerDetailsRQ\Structs\Rail $rail = null)
    {
        $this->Rail = $rail;
        return $this;
    }
    /**
     * Get Seats value
     * @return \Sabre\PassengerDetailsRQ\Structs\Seats|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \Sabre\PassengerDetailsRQ\Structs\Seats $seats
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setSeats(\Sabre\PassengerDetailsRQ\Structs\Seats $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get Surface value
     * @return \Sabre\PassengerDetailsRQ\Structs\Surface|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param \Sabre\PassengerDetailsRQ\Structs\Surface $surface
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setSurface(\Sabre\PassengerDetailsRQ\Structs\Surface $surface = null)
    {
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get Tour value
     * @return \Sabre\PassengerDetailsRQ\Structs\Tour|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param \Sabre\PassengerDetailsRQ\Structs\Tour $tour
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setTour(\Sabre\PassengerDetailsRQ\Structs\Tour $tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \Sabre\PassengerDetailsRQ\Structs\Vehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \Sabre\PassengerDetailsRQ\Structs\Vehicle $vehicle
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setVehicle(\Sabre\PassengerDetailsRQ\Structs\Vehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Product value
     * @return \Sabre\PassengerDetailsRQ\Structs\ProductType|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \Sabre\PassengerDetailsRQ\Structs\ProductType $product
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setProduct(\Sabre\PassengerDetailsRQ\Structs\ProductType $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Ancillaries value
     * @return \Sabre\PassengerDetailsRQ\Structs\Ancillaries|null
     */
    public function getAncillaries()
    {
        return $this->Ancillaries;
    }
    /**
     * Set Ancillaries value
     * @param \Sabre\PassengerDetailsRQ\Structs\Ancillaries $ancillaries
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setAncillaries(\Sabre\PassengerDetailsRQ\Structs\Ancillaries $ancillaries = null)
    {
        $this->Ancillaries = $ancillaries;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
