<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ID Structs
 * @subpackage Structs
 */
class ID extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return the Number associated with the particular hotel reservation if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Number;
    /**
     * Constructor method for ID
     * @uses ID::setNumber()
     * @param string[] $number
     */
    public function __construct(array $number = array())
    {
        $this
            ->setNumber($number);
    }
    /**
     * Get Number value
     * @return string[]|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @throws \InvalidArgumentException
     * @param string[] $number
     * @return \Sabre\PassengerDetailsRQ\Structs\ID
     */
    public function setNumber(array $number = array())
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Add item to Number value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ID
     */
    public function addToNumber($item)
    {
        $this->Number[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
