<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroundTransportationType Structs
 * @subpackage Structs
 */
class GroundTransportationType extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\CompanyType
     */
    public $Vendor;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ServiceType
     */
    public $Service;
    /**
     * The ServiceProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType
     */
    public $ServiceProvider;
    /**
     * The StartDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType
     */
    public $StartDetails;
    /**
     * The StopDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[]
     */
    public $StopDetails;
    /**
     * The EndDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType
     */
    public $EndDetails;
    /**
     * The ExternalReservation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ExternalReservationType
     */
    public $ExternalReservation;
    /**
     * The Restrictions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RestrictionsType
     */
    public $Restrictions;
    /**
     * The POS
     * @var \Sabre\PassengerDetailsRQ\Structs\POSType
     */
    public $POS;
    /**
     * The AgentLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\LoyaltyType[]
     */
    public $AgentLoyalty;
    /**
     * The Passenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\PassengerType[]
     */
    public $Passenger;
    /**
     * The RateQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\RateQualifierType[]
     */
    public $RateQualifier;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ChargesType
     */
    public $Charges;
    /**
     * Constructor method for GroundTransportationType
     * @uses GroundTransportationType::setStatusCode()
     * @uses GroundTransportationType::setVendor()
     * @uses GroundTransportationType::setService()
     * @uses GroundTransportationType::setServiceProvider()
     * @uses GroundTransportationType::setStartDetails()
     * @uses GroundTransportationType::setStopDetails()
     * @uses GroundTransportationType::setEndDetails()
     * @uses GroundTransportationType::setExternalReservation()
     * @uses GroundTransportationType::setRestrictions()
     * @uses GroundTransportationType::setPOS()
     * @uses GroundTransportationType::setAgentLoyalty()
     * @uses GroundTransportationType::setPassenger()
     * @uses GroundTransportationType::setRateQualifier()
     * @uses GroundTransportationType::setCharges()
     * @param string $statusCode
     * @param \Sabre\PassengerDetailsRQ\Structs\CompanyType $vendor
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceType $service
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $serviceProvider
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[] $stopDetails
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails
     * @param \Sabre\PassengerDetailsRQ\Structs\ExternalReservationType $externalReservation
     * @param \Sabre\PassengerDetailsRQ\Structs\RestrictionsType $restrictions
     * @param \Sabre\PassengerDetailsRQ\Structs\POSType $pOS
     * @param \Sabre\PassengerDetailsRQ\Structs\LoyaltyType[] $agentLoyalty
     * @param \Sabre\PassengerDetailsRQ\Structs\PassengerType[] $passenger
     * @param \Sabre\PassengerDetailsRQ\Structs\RateQualifierType[] $rateQualifier
     * @param \Sabre\PassengerDetailsRQ\Structs\ChargesType $charges
     */
    public function __construct($statusCode = null, \Sabre\PassengerDetailsRQ\Structs\CompanyType $vendor = null, \Sabre\PassengerDetailsRQ\Structs\ServiceType $service = null, \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $serviceProvider = null, \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails = null, array $stopDetails = array(), \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails = null, \Sabre\PassengerDetailsRQ\Structs\ExternalReservationType $externalReservation = null, \Sabre\PassengerDetailsRQ\Structs\RestrictionsType $restrictions = null, \Sabre\PassengerDetailsRQ\Structs\POSType $pOS = null, array $agentLoyalty = array(), array $passenger = array(), array $rateQualifier = array(), \Sabre\PassengerDetailsRQ\Structs\ChargesType $charges = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setVendor($vendor)
            ->setService($service)
            ->setServiceProvider($serviceProvider)
            ->setStartDetails($startDetails)
            ->setStopDetails($stopDetails)
            ->setEndDetails($endDetails)
            ->setExternalReservation($externalReservation)
            ->setRestrictions($restrictions)
            ->setPOS($pOS)
            ->setAgentLoyalty($agentLoyalty)
            ->setPassenger($passenger)
            ->setRateQualifier($rateQualifier)
            ->setCharges($charges);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\PassengerDetailsRQ\Structs\CompanyType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\PassengerDetailsRQ\Structs\CompanyType $vendor
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setVendor(\Sabre\PassengerDetailsRQ\Structs\CompanyType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get Service value
     * @return \Sabre\PassengerDetailsRQ\Structs\ServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceType $service
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setService(\Sabre\PassengerDetailsRQ\Structs\ServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get ServiceProvider value
     * @return \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType|null
     */
    public function getServiceProvider()
    {
        return $this->ServiceProvider;
    }
    /**
     * Set ServiceProvider value
     * @param \Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $serviceProvider
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setServiceProvider(\Sabre\PassengerDetailsRQ\Structs\ServiceProviderType $serviceProvider = null)
    {
        $this->ServiceProvider = $serviceProvider;
        return $this;
    }
    /**
     * Get StartDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType|null
     */
    public function getStartDetails()
    {
        return $this->StartDetails;
    }
    /**
     * Set StartDetails value
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setStartDetails(\Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $startDetails = null)
    {
        $this->StartDetails = $startDetails;
        return $this;
    }
    /**
     * Get StopDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[]|null
     */
    public function getStopDetails()
    {
        return $this->StopDetails;
    }
    /**
     * Set StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType[] $stopDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setStopDetails(array $stopDetails = array())
    {
        $this->StopDetails = $stopDetails;
        return $this;
    }
    /**
     * Add item to StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function addToStopDetails(\Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $item)
    {
        $this->StopDetails[] = $item;
        return $this;
    }
    /**
     * Get EndDetails value
     * @return \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType|null
     */
    public function getEndDetails()
    {
        return $this->EndDetails;
    }
    /**
     * Set EndDetails value
     * @param \Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setEndDetails(\Sabre\PassengerDetailsRQ\Structs\LocationDetailsType $endDetails = null)
    {
        $this->EndDetails = $endDetails;
        return $this;
    }
    /**
     * Get ExternalReservation value
     * @return \Sabre\PassengerDetailsRQ\Structs\ExternalReservationType|null
     */
    public function getExternalReservation()
    {
        return $this->ExternalReservation;
    }
    /**
     * Set ExternalReservation value
     * @param \Sabre\PassengerDetailsRQ\Structs\ExternalReservationType $externalReservation
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setExternalReservation(\Sabre\PassengerDetailsRQ\Structs\ExternalReservationType $externalReservation = null)
    {
        $this->ExternalReservation = $externalReservation;
        return $this;
    }
    /**
     * Get Restrictions value
     * @return \Sabre\PassengerDetailsRQ\Structs\RestrictionsType|null
     */
    public function getRestrictions()
    {
        return $this->Restrictions;
    }
    /**
     * Set Restrictions value
     * @param \Sabre\PassengerDetailsRQ\Structs\RestrictionsType $restrictions
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setRestrictions(\Sabre\PassengerDetailsRQ\Structs\RestrictionsType $restrictions = null)
    {
        $this->Restrictions = $restrictions;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\PassengerDetailsRQ\Structs\POSType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\PassengerDetailsRQ\Structs\POSType $pOS
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setPOS(\Sabre\PassengerDetailsRQ\Structs\POSType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get AgentLoyalty value
     * @return \Sabre\PassengerDetailsRQ\Structs\LoyaltyType[]|null
     */
    public function getAgentLoyalty()
    {
        return $this->AgentLoyalty;
    }
    /**
     * Set AgentLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\LoyaltyType[] $agentLoyalty
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setAgentLoyalty(array $agentLoyalty = array())
    {
        $this->AgentLoyalty = $agentLoyalty;
        return $this;
    }
    /**
     * Add item to AgentLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\LoyaltyType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function addToAgentLoyalty(\Sabre\PassengerDetailsRQ\Structs\LoyaltyType $item)
    {
        $this->AgentLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Passenger value
     * @return \Sabre\PassengerDetailsRQ\Structs\PassengerType[]|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PassengerType[] $passenger
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setPassenger(array $passenger = array())
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\PassengerType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function addToPassenger(\Sabre\PassengerDetailsRQ\Structs\PassengerType $item)
    {
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \Sabre\PassengerDetailsRQ\Structs\RateQualifierType[]|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\RateQualifierType[] $rateQualifier
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setRateQualifier(array $rateQualifier = array())
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Add item to RateQualifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\RateQualifierType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function addToRateQualifier(\Sabre\PassengerDetailsRQ\Structs\RateQualifierType $item)
    {
        $this->RateQualifier[] = $item;
        return $this;
    }
    /**
     * Get Charges value
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargesType|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \Sabre\PassengerDetailsRQ\Structs\ChargesType $charges
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public function setCharges(\Sabre\PassengerDetailsRQ\Structs\ChargesType $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\GroundTransportationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
