<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargesType Structs
 * @subpackage Structs
 */
class ChargesType extends AbstractStructBase
{
    /**
     * The GeneralNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GeneralNotes;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ChargeType[]
     */
    public $Charge;
    /**
     * The GrandTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\MoneyType
     */
    public $GrandTotal;
    /**
     * The GeneralBillingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GeneralBillingType;
    /**
     * Constructor method for ChargesType
     * @uses ChargesType::setGeneralNotes()
     * @uses ChargesType::setCharge()
     * @uses ChargesType::setGrandTotal()
     * @uses ChargesType::setGeneralBillingType()
     * @param string $generalNotes
     * @param \Sabre\PassengerDetailsRQ\Structs\ChargeType[] $charge
     * @param \Sabre\PassengerDetailsRQ\Structs\MoneyType $grandTotal
     * @param string $generalBillingType
     */
    public function __construct($generalNotes = null, array $charge = array(), \Sabre\PassengerDetailsRQ\Structs\MoneyType $grandTotal = null, $generalBillingType = null)
    {
        $this
            ->setGeneralNotes($generalNotes)
            ->setCharge($charge)
            ->setGrandTotal($grandTotal)
            ->setGeneralBillingType($generalBillingType);
    }
    /**
     * Get GeneralNotes value
     * @return string|null
     */
    public function getGeneralNotes()
    {
        return $this->GeneralNotes;
    }
    /**
     * Set GeneralNotes value
     * @param string $generalNotes
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargesType
     */
    public function setGeneralNotes($generalNotes = null)
    {
        $this->GeneralNotes = $generalNotes;
        return $this;
    }
    /**
     * Get Charge value
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargeType[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\ChargeType[] $charge
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargesType
     */
    public function setCharge(array $charge = array())
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \Sabre\PassengerDetailsRQ\Structs\ChargeType $item
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargesType
     */
    public function addToCharge(\Sabre\PassengerDetailsRQ\Structs\ChargeType $item)
    {
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Get GrandTotal value
     * @return \Sabre\PassengerDetailsRQ\Structs\MoneyType|null
     */
    public function getGrandTotal()
    {
        return $this->GrandTotal;
    }
    /**
     * Set GrandTotal value
     * @param \Sabre\PassengerDetailsRQ\Structs\MoneyType $grandTotal
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargesType
     */
    public function setGrandTotal(\Sabre\PassengerDetailsRQ\Structs\MoneyType $grandTotal = null)
    {
        $this->GrandTotal = $grandTotal;
        return $this;
    }
    /**
     * Get GeneralBillingType value
     * @return string|null
     */
    public function getGeneralBillingType()
    {
        return $this->GeneralBillingType;
    }
    /**
     * Set GeneralBillingType value
     * @param string $generalBillingType
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargesType
     */
    public function setGeneralBillingType($generalBillingType = null)
    {
        $this->GeneralBillingType = $generalBillingType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\ChargesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
