<?php

namespace Sabre\PassengerDetailsRQ\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardHolderInfo Structs
 * @subpackage Structs
 */
class CardHolderInfo extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\Address
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\PassengerDetailsRQ\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: "Name" is used to return the credit card holder's name.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CardHolderInfo
     * @uses CardHolderInfo::setAddress()
     * @uses CardHolderInfo::setContactNumbers()
     * @uses CardHolderInfo::setName()
     * @param \Sabre\PassengerDetailsRQ\Structs\Address $address
     * @param \Sabre\PassengerDetailsRQ\Structs\ContactNumbers $contactNumbers
     * @param string $name
     */
    public function __construct(\Sabre\PassengerDetailsRQ\Structs\Address $address = null, \Sabre\PassengerDetailsRQ\Structs\ContactNumbers $contactNumbers = null, $name = null)
    {
        $this
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setName($name);
    }
    /**
     * Get Address value
     * @return \Sabre\PassengerDetailsRQ\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\PassengerDetailsRQ\Structs\Address $address
     * @return \Sabre\PassengerDetailsRQ\Structs\CardHolderInfo
     */
    public function setAddress(\Sabre\PassengerDetailsRQ\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\PassengerDetailsRQ\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\PassengerDetailsRQ\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\PassengerDetailsRQ\Structs\CardHolderInfo
     */
    public function setContactNumbers(\Sabre\PassengerDetailsRQ\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\PassengerDetailsRQ\Structs\CardHolderInfo
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\PassengerDetailsRQ\Structs\CardHolderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
