<?php

namespace Sabre\PassengerDetailsRQ\Enums;

/**
 * This class stands for EMDConsummedAtIssuance Enums
 * Meta informations extracted from the WSDL
 * - documentation: "EMDConsumedAtIssuance" indicates that a coupon of an EMD shall be considered "used" at issuance time as defined by the fee owner of the service. It can have following values: Y(Consumed at Issuance), Blank(No application).
 * @subpackage Enumerations
 */
class EMDConsummedAtIssuance
{
    /**
     * Constant for value 'Y'
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Constant for value ' '
     * @return string ' '
     */
    const VALUE_ = ' ';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_Y
     * @uses self::VALUE_N
     * @uses self::VALUE_
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_Y,
            self::VALUE_N,
            self::VALUE_,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
